/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.file.adapter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.connections.file.InMemoryModel;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.entities.ApplicationEntity;
import org.keycloak.models.entities.ClientEntity;
import org.keycloak.models.entities.RoleEntity;
import org.keycloak.models.file.adapter.ClientAdapter;
import org.keycloak.models.file.adapter.RoleAdapter;
import org.keycloak.models.utils.KeycloakModelUtils;

public class ApplicationAdapter
extends ClientAdapter
implements ApplicationModel {
    private final ApplicationEntity applicationEntity;
    private final InMemoryModel inMemoryModel;
    private final Map<String, RoleAdapter> allRoles = new HashMap<String, RoleAdapter>();

    public ApplicationAdapter(KeycloakSession session, RealmModel realm, ApplicationEntity applicationEntity, ClientEntity clientEntity, InMemoryModel inMemoryModel) {
        super(session, realm, clientEntity);
        this.applicationEntity = applicationEntity;
        this.inMemoryModel = inMemoryModel;
    }

    public ApplicationEntity getApplicationEntity() {
        return this.applicationEntity;
    }

    public void updateApplication() {
    }

    public String getName() {
        return this.applicationEntity.getName();
    }

    public void setName(String name) {
        if (this.appNameExists(name)) {
            throw new ModelDuplicateException("Application named " + name + " already exists.");
        }
        this.applicationEntity.setName(name);
    }

    private boolean appNameExists(String name) {
        for (ApplicationModel app : this.realm.getApplications()) {
            if (app == this || !app.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isSurrogateAuthRequired() {
        return this.applicationEntity.isSurrogateAuthRequired();
    }

    public void setSurrogateAuthRequired(boolean surrogateAuthRequired) {
        this.applicationEntity.setSurrogateAuthRequired(surrogateAuthRequired);
    }

    public String getManagementUrl() {
        return this.applicationEntity.getManagementUrl();
    }

    public void setManagementUrl(String url) {
        this.applicationEntity.setManagementUrl(url);
    }

    public void setBaseUrl(String url) {
        this.applicationEntity.setBaseUrl(url);
    }

    public String getBaseUrl() {
        return this.applicationEntity.getBaseUrl();
    }

    public boolean isBearerOnly() {
        return this.applicationEntity.isBearerOnly();
    }

    public void setBearerOnly(boolean only) {
        this.applicationEntity.setBearerOnly(only);
    }

    @Override
    public boolean isPublicClient() {
        return this.applicationEntity.isPublicClient();
    }

    @Override
    public void setPublicClient(boolean flag) {
        this.applicationEntity.setPublicClient(flag);
    }

    public boolean isDirectGrantsOnly() {
        return false;
    }

    public void setDirectGrantsOnly(boolean flag) {
    }

    public RoleAdapter getRole(String name) {
        for (RoleAdapter role : this.allRoles.values()) {
            if (!role.getName().equals(name)) continue;
            return role;
        }
        return null;
    }

    public RoleAdapter addRole(String name) {
        return this.addRole(KeycloakModelUtils.generateId(), name);
    }

    public RoleAdapter addRole(String id, String name) {
        if (this.roleNameExists(name)) {
            throw new ModelDuplicateException("Role named " + name + " already exists.");
        }
        RoleEntity roleEntity = new RoleEntity();
        roleEntity.setId(id);
        roleEntity.setName(name);
        roleEntity.setApplicationId(this.getId());
        RoleAdapter role = new RoleAdapter(this.getRealm(), roleEntity, (RoleContainerModel)this);
        this.allRoles.put(id, role);
        return role;
    }

    private boolean roleNameExists(String name) {
        for (RoleModel roleModel : this.allRoles.values()) {
            if (!roleModel.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean removeRole(RoleModel role) {
        boolean removed = this.allRoles.remove(role.getId()) != null;
        for (UserModel user : this.inMemoryModel.getUsers(this.realm.getId())) {
            user.deleteRoleMapping(role);
        }
        for (ApplicationModel app : this.realm.getApplications()) {
            app.deleteScopeMapping(role);
        }
        for (OAuthClientModel oaClient : this.realm.getOAuthClients()) {
            oaClient.deleteScopeMapping(role);
        }
        this.realm.removeRole(role);
        this.deleteScopeMapping(role);
        return removed;
    }

    public Set<RoleModel> getRoles() {
        return new HashSet<RoleModel>(this.allRoles.values());
    }

    @Override
    public boolean hasScope(RoleModel role) {
        if (super.hasScope(role)) {
            return true;
        }
        Set<RoleModel> roles = this.getRoles();
        if (roles.contains(role)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public Set<RoleModel> getApplicationScopeMappings(ClientModel client) {
        Set allScopes = client.getScopeMappings();
        HashSet<RoleModel> appRoles = new HashSet<RoleModel>();
        for (RoleModel role : allScopes) {
            RoleAdapter roleAdapter = (RoleAdapter)role;
            if (!this.getId().equals(roleAdapter.getRoleEntity().getApplicationId())) continue;
            appRoles.add(role);
        }
        return appRoles;
    }

    public List<String> getDefaultRoles() {
        return this.applicationEntity.getDefaultRoles();
    }

    public void addDefaultRole(String name) {
        List<String> defaultRoles;
        RoleAdapter role = this.getRole(name);
        if (role == null) {
            this.addRole(name);
        }
        if ((defaultRoles = this.getDefaultRoles()).contains(name)) {
            return;
        }
        String[] defaultRoleNames = defaultRoles.toArray(new String[defaultRoles.size() + 1]);
        defaultRoleNames[defaultRoleNames.length - 1] = name;
        this.updateDefaultRoles(defaultRoleNames);
    }

    public void updateDefaultRoles(String[] defaultRoles) {
        ArrayList<String> roleNames = new ArrayList<String>();
        for (String roleName : defaultRoles) {
            RoleAdapter role = this.getRole(roleName);
            if (role == null) {
                this.addRole(roleName);
            }
            roleNames.add(roleName);
        }
        this.applicationEntity.setDefaultRoles(roleNames);
    }

    public int getNodeReRegistrationTimeout() {
        return this.applicationEntity.getNodeReRegistrationTimeout();
    }

    public void setNodeReRegistrationTimeout(int timeout) {
        this.applicationEntity.setNodeReRegistrationTimeout(timeout);
    }

    public Map<String, Integer> getRegisteredNodes() {
        return this.applicationEntity.getRegisteredNodes() == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.applicationEntity.getRegisteredNodes());
    }

    public void registerNode(String nodeHost, int registrationTime) {
        if (this.applicationEntity.getRegisteredNodes() == null) {
            this.applicationEntity.setRegisteredNodes(new HashMap());
        }
        this.applicationEntity.getRegisteredNodes().put(nodeHost, registrationTime);
    }

    public void unregisterNode(String nodeHost) {
        if (this.applicationEntity.getRegisteredNodes() == null) {
            return;
        }
        this.applicationEntity.getRegisteredNodes().remove(nodeHost);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ApplicationModel)) {
            return false;
        }
        ApplicationModel that = (ApplicationModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

