/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.file.adapter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.ClientIdentityProviderMappingModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleModel;
import org.keycloak.models.entities.ClientEntity;
import org.keycloak.models.entities.ClientIdentityProviderMappingEntity;
import org.keycloak.models.entities.ProtocolMapperEntity;
import org.keycloak.models.file.adapter.RoleAdapter;
import org.keycloak.models.utils.KeycloakModelUtils;

public abstract class ClientAdapter
implements ClientModel {
    protected final ClientEntity clientEntity;
    protected final RealmModel realm;
    protected KeycloakSession session;
    private final RealmProvider model;
    private final Map<String, RoleModel> allScopeMappings = new HashMap<String, RoleModel>();

    public ClientAdapter(KeycloakSession session, RealmModel realm, ClientEntity clientEntity) {
        this.clientEntity = clientEntity;
        this.realm = realm;
        this.session = session;
        this.model = session.realms();
    }

    public String getId() {
        return this.clientEntity.getId();
    }

    public String getClientId() {
        return this.clientEntity.getName();
    }

    public Set<String> getWebOrigins() {
        HashSet<String> result = new HashSet<String>();
        if (this.clientEntity.getWebOrigins() != null) {
            result.addAll(this.clientEntity.getWebOrigins());
        }
        return result;
    }

    public void setWebOrigins(Set<String> webOrigins) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(webOrigins);
        this.clientEntity.setWebOrigins(result);
    }

    public void addWebOrigin(String webOrigin) {
        Set<String> webOrigins = this.getWebOrigins();
        webOrigins.add(webOrigin);
        this.setWebOrigins(webOrigins);
    }

    public void removeWebOrigin(String webOrigin) {
        Set<String> webOrigins = this.getWebOrigins();
        webOrigins.remove(webOrigin);
        this.setWebOrigins(webOrigins);
    }

    public Set<String> getRedirectUris() {
        HashSet<String> result = new HashSet<String>();
        if (this.clientEntity.getRedirectUris() != null) {
            result.addAll(this.clientEntity.getRedirectUris());
        }
        return result;
    }

    public void setRedirectUris(Set<String> redirectUris) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(redirectUris);
        this.clientEntity.setRedirectUris(result);
    }

    public void addRedirectUri(String redirectUri) {
        if (this.clientEntity.getRedirectUris().contains(redirectUri)) {
            return;
        }
        this.clientEntity.getRedirectUris().add(redirectUri);
    }

    public void removeRedirectUri(String redirectUri) {
        this.clientEntity.getRedirectUris().remove(redirectUri);
    }

    public boolean isEnabled() {
        return this.clientEntity.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.clientEntity.setEnabled(enabled);
    }

    public boolean validateSecret(String secret) {
        return secret.equals(this.clientEntity.getSecret());
    }

    public String getSecret() {
        return this.clientEntity.getSecret();
    }

    public void setSecret(String secret) {
        this.clientEntity.setSecret(secret);
    }

    public boolean isPublicClient() {
        return this.clientEntity.isPublicClient();
    }

    public void setPublicClient(boolean flag) {
        this.clientEntity.setPublicClient(flag);
    }

    public boolean isFrontchannelLogout() {
        return this.clientEntity.isFrontchannelLogout();
    }

    public void setFrontchannelLogout(boolean flag) {
        this.clientEntity.setFrontchannelLogout(flag);
    }

    public boolean isFullScopeAllowed() {
        return this.clientEntity.isFullScopeAllowed();
    }

    public void setFullScopeAllowed(boolean value) {
        this.clientEntity.setFullScopeAllowed(value);
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public int getNotBefore() {
        return this.clientEntity.getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.clientEntity.setNotBefore(notBefore);
    }

    public Set<RoleModel> getScopeMappings() {
        return new HashSet<RoleModel>(this.allScopeMappings.values());
    }

    public Set<RoleModel> getRealmScopeMappings() {
        Set<RoleModel> allScopes = this.getScopeMappings();
        HashSet<RoleModel> realmRoles = new HashSet<RoleModel>();
        for (RoleModel role : allScopes) {
            RoleAdapter roleAdapter = (RoleAdapter)role;
            if (!roleAdapter.isRealmRole()) continue;
            realmRoles.add(role);
        }
        return realmRoles;
    }

    public boolean hasScope(RoleModel role) {
        if (this.isFullScopeAllowed()) {
            return true;
        }
        Set<RoleModel> roles = this.getScopeMappings();
        if (roles.contains(role)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public void addScopeMapping(RoleModel role) {
        this.allScopeMappings.put(role.getId(), role);
    }

    public void deleteScopeMapping(RoleModel role) {
        this.allScopeMappings.remove(role.getId());
    }

    public String getProtocol() {
        return this.clientEntity.getProtocol();
    }

    public void setProtocol(String protocol) {
        this.clientEntity.setProtocol(protocol);
    }

    public void setAttribute(String name, String value) {
        this.clientEntity.getAttributes().put(name, value);
    }

    public void removeAttribute(String name) {
        this.clientEntity.getAttributes().remove(name);
    }

    public String getAttribute(String name) {
        return (String)this.clientEntity.getAttributes().get(name);
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> copy = new HashMap<String, String>();
        copy.putAll(this.clientEntity.getAttributes());
        return copy;
    }

    public Set<ProtocolMapperModel> getProtocolMappers() {
        HashSet<ProtocolMapperModel> result = new HashSet<ProtocolMapperModel>();
        for (ProtocolMapperEntity entity : this.clientEntity.getProtocolMappers()) {
            ProtocolMapperModel model = this.getProtocolMapperById(entity.getId());
            if (model == null) continue;
            result.add(model);
        }
        return result;
    }

    public ProtocolMapperModel addProtocolMapper(ProtocolMapperModel model) {
        if (this.getProtocolMapperByName(model.getProtocol(), model.getName()) != null) {
            throw new RuntimeException("protocol mapper name must be unique per protocol");
        }
        ProtocolMapperEntity entity = new ProtocolMapperEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setProtocol(model.getProtocol());
        entity.setName(model.getName());
        entity.setProtocolMapper(model.getProtocolMapper());
        entity.setConfig(model.getConfig());
        entity.setConsentRequired(model.isConsentRequired());
        entity.setConsentText(model.getConsentText());
        this.clientEntity.getProtocolMappers().add(entity);
        return this.entityToModel(entity);
    }

    public void removeProtocolMapper(ProtocolMapperModel mapping) {
        ProtocolMapperEntity toBeRemoved = null;
        for (ProtocolMapperEntity entity : this.clientEntity.getProtocolMappers()) {
            if (!entity.getId().equals(mapping.getId())) continue;
            toBeRemoved = entity;
            break;
        }
        this.clientEntity.getProtocolMappers().remove(toBeRemoved);
    }

    public void updateProtocolMapper(ProtocolMapperModel mapping) {
        ProtocolMapperEntity entity = this.getProtocolMapperEntityById(mapping.getId());
        entity.setProtocolMapper(mapping.getProtocolMapper());
        entity.setConsentRequired(mapping.isConsentRequired());
        entity.setConsentText(mapping.getConsentText());
        if (entity.getConfig() != null) {
            entity.getConfig().clear();
            entity.getConfig().putAll(mapping.getConfig());
        } else {
            entity.setConfig(mapping.getConfig());
        }
    }

    protected ProtocolMapperEntity getProtocolMapperEntityById(String id) {
        for (ProtocolMapperEntity entity : this.clientEntity.getProtocolMappers()) {
            if (!entity.getId().equals(id)) continue;
            return entity;
        }
        return null;
    }

    protected ProtocolMapperEntity getProtocolMapperEntityByName(String protocol, String name) {
        for (ProtocolMapperEntity entity : this.clientEntity.getProtocolMappers()) {
            if (!entity.getProtocol().equals(protocol) || !entity.getName().equals(name)) continue;
            return entity;
        }
        return null;
    }

    public ProtocolMapperModel getProtocolMapperById(String id) {
        ProtocolMapperEntity entity = this.getProtocolMapperEntityById(id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public ProtocolMapperModel getProtocolMapperByName(String protocol, String name) {
        ProtocolMapperEntity entity = this.getProtocolMapperEntityByName(protocol, name);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    protected ProtocolMapperModel entityToModel(ProtocolMapperEntity entity) {
        ProtocolMapperModel mapping = new ProtocolMapperModel();
        mapping.setId(entity.getId());
        mapping.setName(entity.getName());
        mapping.setProtocol(entity.getProtocol());
        mapping.setProtocolMapper(entity.getProtocolMapper());
        mapping.setConsentRequired(entity.isConsentRequired());
        mapping.setConsentText(entity.getConsentText());
        HashMap config = new HashMap();
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        mapping.setConfig(config);
        return mapping;
    }

    public void updateIdentityProviders(List<ClientIdentityProviderMappingModel> identityProviders) {
        ArrayList<ClientIdentityProviderMappingEntity> stored = new ArrayList<ClientIdentityProviderMappingEntity>();
        for (ClientIdentityProviderMappingModel model : identityProviders) {
            ClientIdentityProviderMappingEntity entity = new ClientIdentityProviderMappingEntity();
            entity.setId(model.getIdentityProvider());
            entity.setRetrieveToken(model.isRetrieveToken());
            stored.add(entity);
        }
        this.clientEntity.setIdentityProviders(stored);
    }

    public List<ClientIdentityProviderMappingModel> getIdentityProviders() {
        ArrayList<ClientIdentityProviderMappingModel> models = new ArrayList<ClientIdentityProviderMappingModel>();
        for (ClientIdentityProviderMappingEntity entity : this.clientEntity.getIdentityProviders()) {
            ClientIdentityProviderMappingModel model = new ClientIdentityProviderMappingModel();
            model.setIdentityProvider(entity.getId());
            model.setRetrieveToken(entity.isRetrieveToken());
            models.add(model);
        }
        return models;
    }

    public boolean isAllowedRetrieveTokenFromIdentityProvider(String providerId) {
        for (ClientIdentityProviderMappingEntity identityProviderMappingModel : this.clientEntity.getIdentityProviders()) {
            if (!identityProviderMappingModel.getId().equals(providerId)) continue;
            return identityProviderMappingModel.isRetrieveToken();
        }
        return false;
    }
}

