/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.file.adapter;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.connections.file.InMemoryModel;
import org.keycloak.enums.SslRequired;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.entities.ApplicationEntity;
import org.keycloak.models.entities.ClientEntity;
import org.keycloak.models.entities.OAuthClientEntity;
import org.keycloak.models.entities.RealmEntity;
import org.keycloak.models.entities.RequiredCredentialEntity;
import org.keycloak.models.entities.RoleEntity;
import org.keycloak.models.entities.UserFederationProviderEntity;
import org.keycloak.models.file.adapter.ApplicationAdapter;
import org.keycloak.models.file.adapter.OAuthClientAdapter;
import org.keycloak.models.file.adapter.RoleAdapter;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderEvent;

public class RealmAdapter
implements RealmModel {
    private final InMemoryModel inMemoryModel;
    private final RealmEntity realm;
    protected volatile transient PublicKey publicKey;
    protected volatile transient PrivateKey privateKey;
    protected volatile transient X509Certificate certificate;
    protected volatile transient Key codeSecretKey;
    private volatile transient PasswordPolicy passwordPolicy;
    private volatile transient KeycloakSession session;
    private final Map<String, ApplicationModel> allApps = new HashMap<String, ApplicationModel>();
    private ApplicationModel masterAdminApp = null;
    private final Map<String, RoleAdapter> allRoles = new HashMap<String, RoleAdapter>();
    private final Map<String, OAuthClientAdapter> allOAuthClients = new HashMap<String, OAuthClientAdapter>();
    private final Map<String, IdentityProviderModel> allIdProviders = new HashMap<String, IdentityProviderModel>();

    public RealmAdapter(KeycloakSession session, RealmEntity realm, InMemoryModel inMemoryModel) {
        this.session = session;
        this.realm = realm;
        this.inMemoryModel = inMemoryModel;
    }

    public RealmEntity getRealmEnity() {
        return this.realm;
    }

    public String getId() {
        return this.realm.getId();
    }

    public String getName() {
        return this.realm.getName();
    }

    public void setName(String name) {
        if (this.getName() == null) {
            this.realm.setName(name);
            return;
        }
        if (this.getName().equals(name)) {
            return;
        }
        if (this.inMemoryModel.getRealmByName(name) != null) {
            throw new ModelDuplicateException("Realm " + name + " already exists.");
        }
        this.realm.setName(name);
    }

    public boolean isEnabled() {
        return this.realm.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.realm.setEnabled(enabled);
    }

    public SslRequired getSslRequired() {
        return SslRequired.valueOf((String)this.realm.getSslRequired());
    }

    public void setSslRequired(SslRequired sslRequired) {
        this.realm.setSslRequired(sslRequired.name());
    }

    public boolean isPasswordCredentialGrantAllowed() {
        return this.realm.isPasswordCredentialGrantAllowed();
    }

    public void setPasswordCredentialGrantAllowed(boolean passwordCredentialGrantAllowed) {
        this.realm.setPasswordCredentialGrantAllowed(passwordCredentialGrantAllowed);
    }

    public boolean isRegistrationAllowed() {
        return this.realm.isRegistrationAllowed();
    }

    public void setRegistrationAllowed(boolean registrationAllowed) {
        this.realm.setRegistrationAllowed(registrationAllowed);
    }

    public boolean isRegistrationEmailAsUsername() {
        return this.realm.isRegistrationEmailAsUsername();
    }

    public void setRegistrationEmailAsUsername(boolean registrationEmailAsUsername) {
        this.realm.setRegistrationEmailAsUsername(registrationEmailAsUsername);
    }

    public boolean isRememberMe() {
        return this.realm.isRememberMe();
    }

    public void setRememberMe(boolean rememberMe) {
        this.realm.setRememberMe(rememberMe);
    }

    public boolean isBruteForceProtected() {
        return this.realm.isBruteForceProtected();
    }

    public void setBruteForceProtected(boolean value) {
        this.realm.setBruteForceProtected(value);
    }

    public int getMaxFailureWaitSeconds() {
        return this.realm.getMaxFailureWaitSeconds();
    }

    public void setMaxFailureWaitSeconds(int val) {
        this.realm.setMaxFailureWaitSeconds(val);
    }

    public int getWaitIncrementSeconds() {
        return this.realm.getWaitIncrementSeconds();
    }

    public void setWaitIncrementSeconds(int val) {
        this.realm.setWaitIncrementSeconds(val);
    }

    public long getQuickLoginCheckMilliSeconds() {
        return this.realm.getQuickLoginCheckMilliSeconds();
    }

    public void setQuickLoginCheckMilliSeconds(long val) {
        this.realm.setQuickLoginCheckMilliSeconds(val);
    }

    public int getMinimumQuickLoginWaitSeconds() {
        return this.realm.getMinimumQuickLoginWaitSeconds();
    }

    public void setMinimumQuickLoginWaitSeconds(int val) {
        this.realm.setMinimumQuickLoginWaitSeconds(val);
    }

    public int getMaxDeltaTimeSeconds() {
        return this.realm.getMaxDeltaTimeSeconds();
    }

    public void setMaxDeltaTimeSeconds(int val) {
        this.realm.setMaxDeltaTimeSeconds(val);
    }

    public int getFailureFactor() {
        return this.realm.getFailureFactor();
    }

    public void setFailureFactor(int failureFactor) {
        this.realm.setFailureFactor(failureFactor);
    }

    public boolean isVerifyEmail() {
        return this.realm.isVerifyEmail();
    }

    public void setVerifyEmail(boolean verifyEmail) {
        this.realm.setVerifyEmail(verifyEmail);
    }

    public boolean isResetPasswordAllowed() {
        return this.realm.isResetPasswordAllowed();
    }

    public void setResetPasswordAllowed(boolean resetPassword) {
        this.realm.setResetPasswordAllowed(resetPassword);
    }

    public PasswordPolicy getPasswordPolicy() {
        if (this.passwordPolicy == null) {
            this.passwordPolicy = new PasswordPolicy(this.realm.getPasswordPolicy());
        }
        return this.passwordPolicy;
    }

    public void setPasswordPolicy(PasswordPolicy policy) {
        this.passwordPolicy = policy;
        this.realm.setPasswordPolicy(policy.toString());
    }

    public int getNotBefore() {
        return this.realm.getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.realm.setNotBefore(notBefore);
    }

    public int getSsoSessionIdleTimeout() {
        return this.realm.getSsoSessionIdleTimeout();
    }

    public void setSsoSessionIdleTimeout(int seconds) {
        this.realm.setSsoSessionIdleTimeout(seconds);
    }

    public int getSsoSessionMaxLifespan() {
        return this.realm.getSsoSessionMaxLifespan();
    }

    public void setSsoSessionMaxLifespan(int seconds) {
        this.realm.setSsoSessionMaxLifespan(seconds);
    }

    public int getAccessTokenLifespan() {
        return this.realm.getAccessTokenLifespan();
    }

    public void setAccessTokenLifespan(int tokenLifespan) {
        this.realm.setAccessTokenLifespan(tokenLifespan);
    }

    public int getAccessCodeLifespan() {
        return this.realm.getAccessCodeLifespan();
    }

    public void setAccessCodeLifespan(int accessCodeLifespan) {
        this.realm.setAccessCodeLifespan(accessCodeLifespan);
    }

    public int getAccessCodeLifespanUserAction() {
        return this.realm.getAccessCodeLifespanUserAction();
    }

    public void setAccessCodeLifespanUserAction(int accessCodeLifespanUserAction) {
        this.realm.setAccessCodeLifespanUserAction(accessCodeLifespanUserAction);
    }

    public String getPublicKeyPem() {
        return this.realm.getPublicKeyPem();
    }

    public void setPublicKeyPem(String publicKeyPem) {
        this.realm.setPublicKeyPem(publicKeyPem);
        this.publicKey = null;
    }

    public X509Certificate getCertificate() {
        if (this.certificate != null) {
            return this.certificate;
        }
        this.certificate = KeycloakModelUtils.getCertificate((String)this.getCertificatePem());
        return this.certificate;
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
        String certificatePem = KeycloakModelUtils.getPemFromCertificate((X509Certificate)certificate);
        this.setCertificatePem(certificatePem);
    }

    public String getCertificatePem() {
        return this.realm.getCertificatePem();
    }

    public void setCertificatePem(String certificate) {
        this.realm.setCertificatePem(certificate);
    }

    public String getPrivateKeyPem() {
        return this.realm.getPrivateKeyPem();
    }

    public void setPrivateKeyPem(String privateKeyPem) {
        this.realm.setPrivateKeyPem(privateKeyPem);
        this.privateKey = null;
    }

    public PublicKey getPublicKey() {
        if (this.publicKey != null) {
            return this.publicKey;
        }
        this.publicKey = KeycloakModelUtils.getPublicKey((String)this.getPublicKeyPem());
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        String publicKeyPem = KeycloakModelUtils.getPemFromKey((Key)publicKey);
        this.setPublicKeyPem(publicKeyPem);
    }

    public PrivateKey getPrivateKey() {
        if (this.privateKey != null) {
            return this.privateKey;
        }
        this.privateKey = KeycloakModelUtils.getPrivateKey((String)this.getPrivateKeyPem());
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        String privateKeyPem = KeycloakModelUtils.getPemFromKey((Key)privateKey);
        this.setPrivateKeyPem(privateKeyPem);
    }

    public String getCodeSecret() {
        return this.realm.getCodeSecret();
    }

    public Key getCodeSecretKey() {
        if (this.codeSecretKey == null) {
            this.codeSecretKey = KeycloakModelUtils.getSecretKey((String)this.getCodeSecret());
        }
        return this.codeSecretKey;
    }

    public void setCodeSecret(String codeSecret) {
        this.realm.setCodeSecret(codeSecret);
    }

    public String getLoginTheme() {
        return this.realm.getLoginTheme();
    }

    public void setLoginTheme(String name) {
        this.realm.setLoginTheme(name);
    }

    public String getAccountTheme() {
        return this.realm.getAccountTheme();
    }

    public void setAccountTheme(String name) {
        this.realm.setAccountTheme(name);
    }

    public String getAdminTheme() {
        return this.realm.getAdminTheme();
    }

    public void setAdminTheme(String name) {
        this.realm.setAdminTheme(name);
    }

    public String getEmailTheme() {
        return this.realm.getEmailTheme();
    }

    public void setEmailTheme(String name) {
        this.realm.setEmailTheme(name);
    }

    public RoleAdapter getRole(String name) {
        for (RoleAdapter role : this.allRoles.values()) {
            if (!role.getName().equals(name)) continue;
            return role;
        }
        return null;
    }

    public RoleModel addRole(String name) {
        return this.addRole(KeycloakModelUtils.generateId(), name);
    }

    public RoleModel addRole(String id, String name) {
        if (id == null) {
            throw new NullPointerException("id == null");
        }
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (this.hasRoleWithName(name)) {
            throw new ModelDuplicateException("Realm already contains role with name " + name + ".");
        }
        RoleEntity roleEntity = new RoleEntity();
        roleEntity.setId(id);
        roleEntity.setName(name);
        roleEntity.setRealmId(this.getId());
        RoleAdapter roleModel = new RoleAdapter(this, roleEntity, (RoleContainerModel)this);
        this.allRoles.put(id, roleModel);
        return roleModel;
    }

    public boolean removeRole(RoleModel role) {
        return this.removeRoleById(role.getId());
    }

    public boolean removeRoleById(String id) {
        if (id == null) {
            throw new NullPointerException("id == null");
        }
        if (this.allRoles.remove(id) != null) {
            return true;
        }
        for (ApplicationModel app : this.getApplications()) {
            for (RoleModel appRole : app.getRoles()) {
                if (!id.equals(appRole.getId())) continue;
                app.removeRole(appRole);
                return true;
            }
        }
        return false;
    }

    public Set<RoleModel> getRoles() {
        return new HashSet<RoleModel>(this.allRoles.values());
    }

    public RoleModel getRoleById(String id) {
        RoleModel found = this.allRoles.get(id);
        if (found != null) {
            return found;
        }
        for (ApplicationModel app : this.getApplications()) {
            for (RoleModel appRole : app.getRoles()) {
                if (!appRole.getId().equals(id)) continue;
                return appRole;
            }
        }
        return null;
    }

    public List<String> getDefaultRoles() {
        return this.realm.getDefaultRoles();
    }

    public void addDefaultRole(String name) {
        List<String> roleNames;
        RoleAdapter role = this.getRole(name);
        if (role == null) {
            this.addRole(name);
        }
        if ((roleNames = this.getDefaultRoles()).contains(name)) {
            throw new IllegalArgumentException("Realm " + this.realm.getName() + " already contains default role named " + name);
        }
        roleNames.add(name);
        this.realm.setDefaultRoles(roleNames);
    }

    boolean hasRoleWithName(String name) {
        for (RoleModel roleModel : this.allRoles.values()) {
            if (!roleModel.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void updateDefaultRoles(String[] defaultRoles) {
        ArrayList<String> roleNames = new ArrayList<String>();
        for (String roleName : defaultRoles) {
            RoleAdapter role = this.getRole(roleName);
            if (role == null) {
                this.addRole(roleName);
            }
            roleNames.add(roleName);
        }
        this.realm.setDefaultRoles(roleNames);
    }

    public ClientModel findClient(String clientId) {
        ApplicationModel model = this.getApplicationByName(clientId);
        if (model != null) {
            return model;
        }
        return this.getOAuthClient(clientId);
    }

    public ClientModel findClientById(String id) {
        ApplicationModel clientModel = this.getApplicationById(id);
        if (clientModel != null) {
            return clientModel;
        }
        return this.getOAuthClientById(id);
    }

    public ApplicationModel getApplicationById(String id) {
        return this.allApps.get(id);
    }

    public ApplicationModel getApplicationByName(String name) {
        for (ApplicationModel app : this.getApplications()) {
            if (!app.getName().equals(name)) continue;
            return app;
        }
        return null;
    }

    public Map<String, ApplicationModel> getApplicationNameMap() {
        HashMap<String, ApplicationModel> resourceMap = new HashMap<String, ApplicationModel>();
        for (ApplicationModel resource : this.getApplications()) {
            resourceMap.put(resource.getName(), resource);
        }
        return resourceMap;
    }

    public List<ApplicationModel> getApplications() {
        return new ArrayList<ApplicationModel>(this.allApps.values());
    }

    public ApplicationModel addApplication(String name) {
        return this.addApplication(KeycloakModelUtils.generateId(), name);
    }

    public ApplicationModel addApplication(String id, String name) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (id == null) {
            throw new NullPointerException("id == null");
        }
        if (this.getApplicationNameMap().containsKey(name)) {
            throw new ModelDuplicateException("Application named '" + name + "' already exists.");
        }
        ApplicationEntity appEntity = new ApplicationEntity();
        appEntity.setId(id);
        appEntity.setName(name);
        appEntity.setRealmId(this.getId());
        appEntity.setEnabled(true);
        ClientEntity clientEntity = new ClientEntity();
        clientEntity.setId(id);
        clientEntity.setName(name);
        clientEntity.setRealmId(this.getId());
        clientEntity.setEnabled(true);
        final ApplicationAdapter app = new ApplicationAdapter(this.session, this, appEntity, clientEntity, this.inMemoryModel);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new RealmModel.ApplicationCreationEvent(){

            public ApplicationModel getCreatedApplication() {
                return app;
            }

            public ClientModel getCreatedClient() {
                return app;
            }
        });
        this.allApps.put(id, app);
        return app;
    }

    public boolean removeApplication(String id) {
        ApplicationModel appToBeRemoved = this.getApplicationById(id);
        if (appToBeRemoved == null) {
            return false;
        }
        for (RoleModel role : this.getRoles()) {
            RoleAdapter roleAdapter = (RoleAdapter)role;
            roleAdapter.removeApplicationComposites(id);
        }
        for (RoleModel role : appToBeRemoved.getRoles()) {
            appToBeRemoved.removeRole(role);
        }
        return this.allApps.remove(id) != null;
    }

    public OAuthClientModel addOAuthClient(String name) {
        return this.addOAuthClient(KeycloakModelUtils.generateId(), name);
    }

    public OAuthClientModel addOAuthClient(String id, String name) {
        if (id == null) {
            throw new NullPointerException("id == null");
        }
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (this.hasOAuthClientWithName(name)) {
            throw new ModelDuplicateException("OAuth Client with name " + name + " already exists.");
        }
        OAuthClientEntity oauthClient = new OAuthClientEntity();
        oauthClient.setId(id);
        oauthClient.setRealmId(this.getId());
        oauthClient.setName(name);
        OAuthClientAdapter oAuthClient = new OAuthClientAdapter(this.session, (RealmModel)this, oauthClient);
        this.allOAuthClients.put(id, oAuthClient);
        return oAuthClient;
    }

    boolean hasOAuthClientWithName(String name) {
        for (OAuthClientAdapter oaClient : this.allOAuthClients.values()) {
            if (!oaClient.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    boolean hasOAuthClientWithClientId(String id) {
        for (OAuthClientAdapter oaClient : this.allOAuthClients.values()) {
            if (!oaClient.getClientId().equals(id)) continue;
            return true;
        }
        return false;
    }

    boolean hasUserWithEmail(String email) {
        for (UserModel user : this.inMemoryModel.getUsers(this.getId())) {
            if (user.getEmail() == null || !user.getEmail().equals(email)) continue;
            return true;
        }
        return false;
    }

    public boolean removeOAuthClient(String id) {
        return this.allOAuthClients.remove(id) != null;
    }

    public OAuthClientModel getOAuthClient(String name) {
        for (OAuthClientAdapter oAuthClient : this.allOAuthClients.values()) {
            if (!oAuthClient.getName().equals(name)) continue;
            return oAuthClient;
        }
        return null;
    }

    public OAuthClientModel getOAuthClientById(String id) {
        for (OAuthClientAdapter oAuthClient : this.allOAuthClients.values()) {
            if (!oAuthClient.getId().equals(id)) continue;
            return oAuthClient;
        }
        return null;
    }

    public List<OAuthClientModel> getOAuthClients() {
        return new ArrayList<OAuthClientModel>(this.allOAuthClients.values());
    }

    public void addRequiredCredential(String type) {
        if (type == null) {
            throw new NullPointerException("Credential type can not be null");
        }
        RequiredCredentialModel credentialModel = this.initRequiredCredentialModel(type);
        List requiredCredList = this.realm.getRequiredCredentials();
        for (RequiredCredentialEntity cred : requiredCredList) {
            if (!type.equals(cred.getType())) continue;
            return;
        }
        this.addRequiredCredential(credentialModel, requiredCredList);
    }

    protected void addRequiredCredential(RequiredCredentialModel credentialModel, List<RequiredCredentialEntity> persistentCollection) {
        RequiredCredentialEntity credEntity = new RequiredCredentialEntity();
        credEntity.setType(credentialModel.getType());
        credEntity.setFormLabel(credentialModel.getFormLabel());
        credEntity.setInput(credentialModel.isInput());
        credEntity.setSecret(credentialModel.isSecret());
        persistentCollection.add(credEntity);
    }

    public void updateRequiredCredentials(Set<String> creds) {
        this.updateRequiredCredentials(creds, this.realm.getRequiredCredentials());
    }

    protected void updateRequiredCredentials(Set<String> creds, List<RequiredCredentialEntity> credsEntities) {
        HashSet<String> already = new HashSet<String>();
        HashSet<RequiredCredentialEntity> toRemove = new HashSet<RequiredCredentialEntity>();
        for (RequiredCredentialEntity entity : credsEntities) {
            if (!creds.contains(entity.getType())) {
                toRemove.add(entity);
                continue;
            }
            already.add(entity.getType());
        }
        for (RequiredCredentialEntity entity : toRemove) {
            credsEntities.remove(entity);
        }
        for (String cred : creds) {
            if (already.contains(cred)) continue;
            RequiredCredentialModel credentialModel = this.initRequiredCredentialModel(cred);
            this.addRequiredCredential(credentialModel, credsEntities);
        }
    }

    public List<RequiredCredentialModel> getRequiredCredentials() {
        return this.convertRequiredCredentialEntities(this.realm.getRequiredCredentials());
    }

    protected List<RequiredCredentialModel> convertRequiredCredentialEntities(Collection<RequiredCredentialEntity> credEntities) {
        ArrayList<RequiredCredentialModel> result = new ArrayList<RequiredCredentialModel>();
        for (RequiredCredentialEntity entity : credEntities) {
            RequiredCredentialModel credentialModel = new RequiredCredentialModel();
            credentialModel.setFormLabel(entity.getFormLabel());
            credentialModel.setInput(entity.isInput());
            credentialModel.setSecret(entity.isSecret());
            credentialModel.setType(entity.getType());
            result.add(credentialModel);
        }
        return result;
    }

    protected RequiredCredentialModel initRequiredCredentialModel(String type) {
        RequiredCredentialModel credentialModel = (RequiredCredentialModel)RequiredCredentialModel.BUILT_IN.get(type);
        if (credentialModel == null) {
            throw new RuntimeException("Unknown credential type " + type);
        }
        return credentialModel;
    }

    public Map<String, String> getBrowserSecurityHeaders() {
        return this.realm.getBrowserSecurityHeaders();
    }

    public void setBrowserSecurityHeaders(Map<String, String> headers) {
        this.realm.setBrowserSecurityHeaders(headers);
    }

    public Map<String, String> getSmtpConfig() {
        return this.realm.getSmtpConfig();
    }

    public void setSmtpConfig(Map<String, String> smtpConfig) {
        this.realm.setSmtpConfig(smtpConfig);
    }

    public List<IdentityProviderModel> getIdentityProviders() {
        return new ArrayList<IdentityProviderModel>(this.allIdProviders.values());
    }

    public IdentityProviderModel getIdentityProviderByAlias(String alias) {
        for (IdentityProviderModel identityProviderModel : this.getIdentityProviders()) {
            if (!identityProviderModel.getAlias().equals(alias)) continue;
            return identityProviderModel;
        }
        return null;
    }

    public void addIdentityProvider(IdentityProviderModel identityProvider) {
        if (identityProvider.getAlias() == null) {
            throw new NullPointerException("identityProvider.getAlias() == null");
        }
        if (identityProvider.getInternalId() == null) {
            identityProvider.setInternalId(KeycloakModelUtils.generateId());
        }
        this.allIdProviders.put(identityProvider.getInternalId(), identityProvider);
    }

    public void removeIdentityProviderByAlias(String alias) {
        for (IdentityProviderModel provider : this.getIdentityProviders()) {
            if (!provider.getAlias().equals(alias)) continue;
            this.allIdProviders.remove(provider.getInternalId());
            break;
        }
    }

    public void updateIdentityProvider(IdentityProviderModel identityProvider) {
        this.removeIdentityProviderByAlias(identityProvider.getAlias());
        this.addIdentityProvider(identityProvider);
    }

    public UserFederationProviderModel addUserFederationProvider(String providerName, Map<String, String> config, int priority, String displayName, int fullSyncPeriod, int changedSyncPeriod, int lastSync) {
        UserFederationProviderEntity entity = new UserFederationProviderEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setPriority(priority);
        entity.setProviderName(providerName);
        entity.setConfig(config);
        if (displayName == null) {
            displayName = entity.getId();
        }
        entity.setDisplayName(displayName);
        entity.setFullSyncPeriod(fullSyncPeriod);
        entity.setChangedSyncPeriod(changedSyncPeriod);
        entity.setLastSync(lastSync);
        this.realm.getUserFederationProviders().add(entity);
        return new UserFederationProviderModel(entity.getId(), providerName, config, priority, displayName, fullSyncPeriod, changedSyncPeriod, lastSync);
    }

    public void removeUserFederationProvider(UserFederationProviderModel provider) {
        Iterator it = this.realm.getUserFederationProviders().iterator();
        while (it.hasNext()) {
            UserFederationProviderEntity entity = (UserFederationProviderEntity)it.next();
            if (!entity.getId().equals(provider.getId())) continue;
            this.session.users().preRemove((RealmModel)this, new UserFederationProviderModel(entity.getId(), entity.getProviderName(), entity.getConfig(), entity.getPriority(), entity.getDisplayName(), entity.getFullSyncPeriod(), entity.getChangedSyncPeriod(), entity.getLastSync()));
            it.remove();
        }
    }

    public void updateUserFederationProvider(UserFederationProviderModel model) {
        for (UserFederationProviderEntity entity : this.realm.getUserFederationProviders()) {
            if (!entity.getId().equals(model.getId())) continue;
            entity.setProviderName(model.getProviderName());
            entity.setConfig(model.getConfig());
            entity.setPriority(model.getPriority());
            String displayName = model.getDisplayName();
            if (displayName != null) {
                entity.setDisplayName(model.getDisplayName());
            }
            entity.setFullSyncPeriod(model.getFullSyncPeriod());
            entity.setChangedSyncPeriod(model.getChangedSyncPeriod());
            entity.setLastSync(model.getLastSync());
        }
    }

    public List<UserFederationProviderModel> getUserFederationProviders() {
        List entities = this.realm.getUserFederationProviders();
        LinkedList<UserFederationProviderEntity> copy = new LinkedList<UserFederationProviderEntity>();
        for (UserFederationProviderEntity entity : entities) {
            copy.add(entity);
        }
        Collections.sort(copy, new Comparator<UserFederationProviderEntity>(){

            @Override
            public int compare(UserFederationProviderEntity o1, UserFederationProviderEntity o2) {
                return o1.getPriority() - o2.getPriority();
            }
        });
        LinkedList<UserFederationProviderModel> result = new LinkedList<UserFederationProviderModel>();
        for (UserFederationProviderEntity entity : copy) {
            result.add(new UserFederationProviderModel(entity.getId(), entity.getProviderName(), entity.getConfig(), entity.getPriority(), entity.getDisplayName(), entity.getFullSyncPeriod(), entity.getChangedSyncPeriod(), entity.getLastSync()));
        }
        return result;
    }

    public void setUserFederationProviders(List<UserFederationProviderModel> providers) {
        LinkedList<UserFederationProviderEntity> entities = new LinkedList<UserFederationProviderEntity>();
        for (UserFederationProviderModel model : providers) {
            UserFederationProviderEntity entity = new UserFederationProviderEntity();
            if (model.getId() != null) {
                entity.setId(model.getId());
            } else {
                entity.setId(KeycloakModelUtils.generateId());
            }
            entity.setProviderName(model.getProviderName());
            entity.setConfig(model.getConfig());
            entity.setPriority(model.getPriority());
            String displayName = model.getDisplayName();
            if (displayName == null) {
                entity.setDisplayName(entity.getId());
            }
            entity.setDisplayName(displayName);
            entity.setFullSyncPeriod(model.getFullSyncPeriod());
            entity.setChangedSyncPeriod(model.getChangedSyncPeriod());
            entity.setLastSync(model.getLastSync());
            entities.add(entity);
        }
        this.realm.setUserFederationProviders(entities);
    }

    public boolean isEventsEnabled() {
        return this.realm.isEventsEnabled();
    }

    public void setEventsEnabled(boolean enabled) {
        this.realm.setEventsEnabled(enabled);
    }

    public long getEventsExpiration() {
        return this.realm.getEventsExpiration();
    }

    public void setEventsExpiration(long expiration) {
        this.realm.setEventsExpiration(expiration);
    }

    public Set<String> getEventsListeners() {
        return new HashSet<String>(this.realm.getEventsListeners());
    }

    public void setEventsListeners(Set<String> listeners) {
        if (listeners != null) {
            this.realm.setEventsListeners(new ArrayList<String>(listeners));
        } else {
            this.realm.setEventsListeners(Collections.EMPTY_LIST);
        }
    }

    public Set<String> getEnabledEventTypes() {
        return new HashSet<String>(this.realm.getEnabledEventTypes());
    }

    public void setEnabledEventTypes(Set<String> enabledEventTypes) {
        if (enabledEventTypes != null) {
            this.realm.setEnabledEventTypes(new ArrayList<String>(enabledEventTypes));
        } else {
            this.realm.setEnabledEventTypes(Collections.EMPTY_LIST);
        }
    }

    public ApplicationModel getMasterAdminApp() {
        return this.masterAdminApp;
    }

    public void setMasterAdminApp(ApplicationModel app) {
        if (app == null) {
            this.realm.setAdminAppId(null);
            this.masterAdminApp = null;
        } else {
            String appId = app.getId();
            if (appId == null) {
                throw new IllegalStateException("Master Admin app not initialized.");
            }
            this.realm.setAdminAppId(appId);
            this.masterAdminApp = app;
        }
    }

    public boolean isIdentityFederationEnabled() {
        return this.getIdentityProviders() != null && !this.getIdentityProviders().isEmpty();
    }

    public int getAccessCodeLifespanLogin() {
        return this.realm.getAccessCodeLifespanLogin();
    }

    public void setAccessCodeLifespanLogin(int accessCodeLifespanLogin) {
        this.realm.setAccessCodeLifespanLogin(accessCodeLifespanLogin);
    }

    public boolean isInternationalizationEnabled() {
        return this.realm.isInternationalizationEnabled();
    }

    public void setInternationalizationEnabled(boolean enabled) {
        this.realm.setInternationalizationEnabled(enabled);
    }

    public Set<String> getSupportedLocales() {
        return new HashSet<String>(this.realm.getSupportedLocales());
    }

    public void setSupportedLocales(Set<String> locales) {
        this.realm.setSupportedLocales(new ArrayList<String>(locales));
    }

    public String getDefaultLocale() {
        return this.realm.getDefaultLocale();
    }

    public void setDefaultLocale(String locale) {
        this.realm.setDefaultLocale(locale);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof RealmModel)) {
            return false;
        }
        RealmModel that = (RealmModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

