/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.file.adapter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.entities.RoleEntity;
import org.keycloak.models.file.adapter.RealmAdapter;
import org.keycloak.models.utils.KeycloakModelUtils;

public class RoleAdapter
implements RoleModel {
    private final RoleEntity role;
    private RoleContainerModel roleContainer;
    private final RealmModel realm;
    private final Set<RoleModel> compositeRoles = new HashSet<RoleModel>();

    public RoleAdapter(RealmModel realm, RoleEntity roleEntity) {
        this(realm, roleEntity, null);
    }

    public RoleAdapter(RealmModel realm, RoleEntity roleEntity, RoleContainerModel roleContainer) {
        this.role = roleEntity;
        this.roleContainer = roleContainer;
        this.realm = realm;
    }

    public RoleEntity getRoleEntity() {
        return this.role;
    }

    public boolean isRealmRole() {
        return this.role.getRealmId() != null;
    }

    public String getId() {
        return this.role.getId();
    }

    public String getName() {
        return this.role.getName();
    }

    public void setName(String name) {
        RealmAdapter realmAdapter = (RealmAdapter)this.realm;
        if (this.role.getName().equals(name)) {
            return;
        }
        if (realmAdapter.hasRoleWithName(name)) {
            throw new ModelDuplicateException("Role name " + name + " already exists.");
        }
        this.role.setName(name);
    }

    public String getDescription() {
        return this.role.getDescription();
    }

    public void setDescription(String description) {
        this.role.setDescription(description);
    }

    public boolean isComposite() {
        return this.role.getCompositeRoleIds() != null && this.role.getCompositeRoleIds().size() > 0;
    }

    public void addCompositeRole(RoleModel childRole) {
        ArrayList<String> compositeRoleIds = this.role.getCompositeRoleIds();
        if (compositeRoleIds == null) {
            compositeRoleIds = new ArrayList<String>();
        }
        compositeRoleIds.add(childRole.getId());
        this.role.setCompositeRoleIds(compositeRoleIds);
        this.compositeRoles.add(childRole);
    }

    public void removeApplicationComposites(String appId) {
        if (!this.isComposite()) {
            return;
        }
        HashSet<RoleModel> toBeRemoved = new HashSet<RoleModel>();
        for (RoleModel compositeRole : this.getComposites()) {
            RoleAdapter roleAdapter = (RoleAdapter)compositeRole;
            if (appId.equals(roleAdapter.getRoleEntity().getApplicationId())) {
                toBeRemoved.add(compositeRole);
                continue;
            }
            roleAdapter.removeApplicationComposites(appId);
        }
        for (RoleModel compositeRole : toBeRemoved) {
            this.removeCompositeRole(compositeRole);
        }
    }

    public void removeCompositeRole(RoleModel childRole) {
        this.compositeRoles.remove(childRole);
        List compositeRoleIds = this.role.getCompositeRoleIds();
        if (compositeRoleIds == null) {
            return;
        }
        compositeRoleIds.remove(childRole.getId());
        this.role.setCompositeRoleIds(compositeRoleIds);
    }

    public Set<RoleModel> getComposites() {
        return Collections.unmodifiableSet(this.compositeRoles);
    }

    public RoleContainerModel getContainer() {
        if (this.roleContainer == null) {
            if (this.role.getRealmId() != null) {
                this.roleContainer = this.realm;
            } else if (this.role.getApplicationId() != null) {
                this.roleContainer = this.realm.getApplicationById(this.role.getApplicationId());
            } else {
                throw new IllegalStateException("Both realmId and applicationId are null for role: " + this);
            }
        }
        return this.roleContainer;
    }

    public boolean hasRole(RoleModel role) {
        if (this.equals(role)) {
            return true;
        }
        if (!this.isComposite()) {
            return false;
        }
        HashSet visited = new HashSet();
        return KeycloakModelUtils.searchFor((RoleModel)role, (RoleModel)this, visited);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof RoleModel)) {
            return false;
        }
        RoleModel that = (RoleModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

