/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.AbstractLoginProtocolFactory;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.saml.SamlProtocol;
import org.keycloak.protocol.saml.SamlService;
import org.keycloak.protocol.saml.mappers.RoleListMapper;
import org.keycloak.protocol.saml.mappers.UserPropertyAttributeStatementMapper;
import org.keycloak.services.managers.AuthenticationManager;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.saml.v2.constants.X500SAMLProfileConstants;
import org.picketlink.identity.federation.core.sts.PicketLinkCoreSTS;

public class SamlProtocolFactory
extends AbstractLoginProtocolFactory {
    static List<ProtocolMapperModel> builtins = new ArrayList<ProtocolMapperModel>();
    static List<ProtocolMapperModel> defaultBuiltins = new ArrayList<ProtocolMapperModel>();

    public Object createProtocolEndpoint(RealmModel realm, EventBuilder event, AuthenticationManager authManager) {
        return new SamlService(realm, event, authManager);
    }

    public LoginProtocol create(KeycloakSession session) {
        return new SamlProtocol().setSession(session);
    }

    public void init(Config.Scope config) {
        PicketLinkCoreSTS sts = PicketLinkCoreSTS.instance();
        sts.installDefaultConfiguration(new String[0]);
    }

    public String getId() {
        return "saml";
    }

    public List<ProtocolMapperModel> getBuiltinMappers() {
        return builtins;
    }

    public List<ProtocolMapperModel> getDefaultBuiltinMappers() {
        return defaultBuiltins;
    }

    protected void addDefaults(ClientModel client) {
        for (ProtocolMapperModel model : defaultBuiltins) {
            client.addProtocolMapper(model);
        }
    }

    static {
        ProtocolMapperModel model = UserPropertyAttributeStatementMapper.createAttributeMapper("X500 email", "email", X500SAMLProfileConstants.EMAIL.get(), JBossSAMLURIConstants.ATTRIBUTE_FORMAT_URI.get(), X500SAMLProfileConstants.EMAIL.getFriendlyName(), true, "${email}");
        builtins.add(model);
        model = UserPropertyAttributeStatementMapper.createAttributeMapper("X500 givenName", "firstName", X500SAMLProfileConstants.GIVEN_NAME.get(), JBossSAMLURIConstants.ATTRIBUTE_FORMAT_URI.get(), X500SAMLProfileConstants.GIVEN_NAME.getFriendlyName(), true, "${givenName}");
        builtins.add(model);
        model = UserPropertyAttributeStatementMapper.createAttributeMapper("X500 surname", "lastName", X500SAMLProfileConstants.SURNAME.get(), JBossSAMLURIConstants.ATTRIBUTE_FORMAT_URI.get(), X500SAMLProfileConstants.SURNAME.getFriendlyName(), true, "${familyName}");
        builtins.add(model);
        model = RoleListMapper.create("role list", "Role", "Basic", null, false);
        builtins.add(model);
        defaultBuiltins.add(model);
    }
}

