/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.account.freemarker.model;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.UriBuilder;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.resources.AccountService;
import org.keycloak.services.resources.flows.Urls;

public class AccountFederatedIdentityBean {
    private final List<FederatedIdentityEntry> identities;
    private final boolean removeLinkPossible;
    private final KeycloakSession session;

    public AccountFederatedIdentityBean(KeycloakSession session, RealmModel realm, UserModel user, URI baseUri, String stateChecker) {
        this.session = session;
        URI accountIdentityUpdateUri = Urls.accountFederatedIdentityUpdate((URI)baseUri, (String)realm.getName());
        this.identities = new LinkedList<FederatedIdentityEntry>();
        List identityProviders = realm.getIdentityProviders();
        Set identities = session.users().getFederatedIdentities(user, realm);
        int availableIdentities = 0;
        if (identityProviders != null && !identityProviders.isEmpty()) {
            for (IdentityProviderModel provider : identityProviders) {
                String providerId = provider.getAlias();
                FederatedIdentityModel identity = this.getIdentity(identities, providerId);
                if (identity != null) {
                    ++availableIdentities;
                }
                String action = identity != null ? "remove" : "add";
                String actionUrl = UriBuilder.fromUri((URI)accountIdentityUpdateUri).queryParam("action", new Object[]{action}).queryParam("provider_id", new Object[]{providerId}).queryParam("stateChecker", new Object[]{stateChecker}).build(new Object[0]).toString();
                FederatedIdentityEntry entry = new FederatedIdentityEntry(identity, provider.getAlias(), provider.getAlias(), actionUrl);
                this.identities.add(entry);
            }
        }
        this.removeLinkPossible = availableIdentities > 1 || user.getFederationLink() != null || AccountService.isPasswordSet((UserModel)user);
    }

    private FederatedIdentityModel getIdentity(Set<FederatedIdentityModel> identities, String providerId) {
        for (FederatedIdentityModel link : identities) {
            if (!providerId.equals(link.getIdentityProvider())) continue;
            return link;
        }
        return null;
    }

    public List<FederatedIdentityEntry> getIdentities() {
        return this.identities;
    }

    public boolean isRemoveLinkPossible() {
        return this.removeLinkPossible;
    }

    public class FederatedIdentityEntry {
        private FederatedIdentityModel federatedIdentityModel;
        private final String providerId;
        private final String providerName;
        private final String actionUrl;

        public FederatedIdentityEntry(FederatedIdentityModel federatedIdentityModel, String providerId, String providerName, String actionUrl) {
            this.federatedIdentityModel = federatedIdentityModel;
            this.providerId = providerId;
            this.providerName = providerName;
            this.actionUrl = actionUrl;
        }

        public String getProviderId() {
            return this.providerId;
        }

        public String getProviderName() {
            return this.providerName;
        }

        public String getUserId() {
            return this.federatedIdentityModel != null ? this.federatedIdentityModel.getUserId() : null;
        }

        public String getUserName() {
            return this.federatedIdentityModel != null ? this.federatedIdentityModel.getUserName() : null;
        }

        public boolean isConnected() {
            return this.federatedIdentityModel != null;
        }

        public String getActionUrl() {
            return this.actionUrl;
        }
    }
}

