/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.IdentityProviderFactory;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.services.managers.ResourceAdminManager;
import org.keycloak.services.resources.admin.IdentityProviderResource;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.services.resources.flows.Flows;
import org.keycloak.social.SocialIdentityProvider;

public class IdentityProvidersResource {
    private final RealmModel realm;
    private final KeycloakSession session;
    private RealmAuth auth;

    public IdentityProvidersResource(RealmModel realm, KeycloakSession session, RealmAuth auth) {
        this.realm = realm;
        this.session = session;
        this.auth = auth;
        this.auth.init(RealmAuth.Resource.IDENTITY_PROVIDER);
    }

    @Path(value="/providers/{provider_id}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response getIdentityProviders(@PathParam(value="provider_id") String providerId) {
        this.auth.requireView();
        IdentityProviderFactory providerFactory = this.getProviderFactorytById(providerId);
        if (providerFactory != null) {
            return Response.ok((Object)providerFactory).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @POST
    @Path(value="import-config")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Map<String, String> importFrom(@Context UriInfo uriInfo, MultipartFormDataInput input) throws IOException {
        this.auth.requireManage();
        Map formDataMap = input.getFormDataMap();
        String providerId = ((InputPart)((List)formDataMap.get("providerId")).get(0)).getBodyAsString();
        InputPart file = (InputPart)((List)formDataMap.get("file")).get(0);
        InputStream inputStream = (InputStream)file.getBody(InputStream.class, null);
        IdentityProviderFactory providerFactory = this.getProviderFactorytById(providerId);
        Map config = providerFactory.parseConfig(inputStream);
        return config;
    }

    @POST
    @Path(value="import-config")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Map<String, String> importFrom(@Context UriInfo uriInfo, Map<String, Object> data) throws IOException {
        this.auth.requireManage();
        String providerId = data.get("providerId").toString();
        String from = data.get("fromUrl").toString();
        ApacheHttpClient4Executor executor = ResourceAdminManager.createExecutor();
        InputStream inputStream = null;
        try {
            inputStream = (InputStream)executor.createRequest(from).getTarget(InputStream.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        IdentityProviderFactory providerFactory = this.getProviderFactorytById(providerId);
        Map config = providerFactory.parseConfig(inputStream);
        return config;
    }

    @GET
    @Path(value="instances")
    @NoCache
    @Produces(value={"application/json"})
    public List<IdentityProviderRepresentation> getIdentityProviders() {
        this.auth.requireView();
        ArrayList<IdentityProviderRepresentation> representations = new ArrayList<IdentityProviderRepresentation>();
        for (IdentityProviderModel identityProviderModel : this.realm.getIdentityProviders()) {
            representations.add(ModelToRepresentation.toRepresentation((IdentityProviderModel)identityProviderModel));
        }
        return representations;
    }

    @POST
    @Path(value="instances")
    @Consumes(value={"application/json"})
    public Response create(@Context UriInfo uriInfo, IdentityProviderRepresentation representation) {
        this.auth.requireManage();
        try {
            this.realm.addIdentityProvider(RepresentationToModel.toModel((IdentityProviderRepresentation)representation));
            return Response.created((URI)uriInfo.getAbsolutePathBuilder().path(representation.getProviderId()).build(new Object[0])).build();
        }
        catch (ModelDuplicateException e) {
            return Flows.errors().exists("Identity Provider " + representation.getAlias() + " already exists");
        }
    }

    @Path(value="instances/{alias}")
    public IdentityProviderResource getIdentityProvider(@PathParam(value="alias") String alias) {
        this.auth.requireView();
        IdentityProviderModel identityProviderModel = null;
        for (IdentityProviderModel storedIdentityProvider : this.realm.getIdentityProviders()) {
            if (!storedIdentityProvider.getAlias().equals(alias) && !storedIdentityProvider.getInternalId().equals(alias)) continue;
            identityProviderModel = storedIdentityProvider;
        }
        if (identityProviderModel == null) {
            throw new NotFoundException("Could not find identity provider: " + alias);
        }
        IdentityProviderResource identityProviderResource = new IdentityProviderResource(this.auth, this.realm, this.session, identityProviderModel);
        ResteasyProviderFactory.getInstance().injectProperties((Object)identityProviderResource);
        return identityProviderResource;
    }

    private IdentityProviderFactory getProviderFactorytById(String providerId) {
        List<ProviderFactory> allProviders = this.getProviderFactories();
        for (ProviderFactory providerFactory : allProviders) {
            if (!providerFactory.getId().equals(providerId)) continue;
            return (IdentityProviderFactory)providerFactory;
        }
        return null;
    }

    private List<ProviderFactory> getProviderFactories() {
        ArrayList<ProviderFactory> allProviders = new ArrayList<ProviderFactory>();
        allProviders.addAll(this.session.getKeycloakSessionFactory().getProviderFactories(IdentityProvider.class));
        allProviders.addAll(this.session.getKeycloakSessionFactory().getProviderFactories(SocialIdentityProvider.class));
        return allProviders;
    }
}

