/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.connections.mongo.api.MongoIdentifiableEntity;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.ClientIdentityProviderMappingModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.entities.ClientEntity;
import org.keycloak.models.entities.ClientIdentityProviderMappingEntity;
import org.keycloak.models.entities.ProtocolMapperEntity;
import org.keycloak.models.mongo.keycloak.adapters.AbstractMongoAdapter;
import org.keycloak.models.mongo.keycloak.adapters.RoleAdapter;
import org.keycloak.models.mongo.keycloak.entities.MongoRoleEntity;
import org.keycloak.models.mongo.utils.MongoModelUtils;
import org.keycloak.models.utils.KeycloakModelUtils;

public abstract class ClientAdapter<T extends MongoIdentifiableEntity>
extends AbstractMongoAdapter<T>
implements ClientModel {
    protected final T clientEntity;
    private final RealmModel realm;
    protected KeycloakSession session;

    public ClientAdapter(KeycloakSession session, RealmModel realm, T clientEntity, MongoStoreInvocationContext invContext) {
        super(invContext);
        this.clientEntity = clientEntity;
        this.realm = realm;
        this.session = session;
    }

    @Override
    public T getMongoEntity() {
        return this.clientEntity;
    }

    public ClientEntity getMongoEntityAsClient() {
        return (ClientEntity)this.getMongoEntity();
    }

    public String getId() {
        return this.getMongoEntity().getId();
    }

    public String getClientId() {
        return this.getMongoEntityAsClient().getName();
    }

    public Set<String> getWebOrigins() {
        HashSet<String> result = new HashSet<String>();
        if (this.getMongoEntityAsClient().getWebOrigins() != null) {
            result.addAll(this.getMongoEntityAsClient().getWebOrigins());
        }
        return result;
    }

    public void setWebOrigins(Set<String> webOrigins) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(webOrigins);
        this.getMongoEntityAsClient().setWebOrigins(result);
        this.updateMongoEntity();
    }

    public void addWebOrigin(String webOrigin) {
        this.getMongoStore().pushItemToList(this.clientEntity, "webOrigins", (Object)webOrigin, true, this.invocationContext);
    }

    public void removeWebOrigin(String webOrigin) {
        this.getMongoStore().pullItemFromList(this.clientEntity, "webOrigins", (Object)webOrigin, this.invocationContext);
    }

    public Set<String> getRedirectUris() {
        HashSet<String> result = new HashSet<String>();
        if (this.getMongoEntityAsClient().getRedirectUris() != null) {
            result.addAll(this.getMongoEntityAsClient().getRedirectUris());
        }
        return result;
    }

    public void setRedirectUris(Set<String> redirectUris) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(redirectUris);
        this.getMongoEntityAsClient().setRedirectUris(result);
        this.updateMongoEntity();
    }

    public void addRedirectUri(String redirectUri) {
        this.getMongoStore().pushItemToList(this.clientEntity, "redirectUris", (Object)redirectUri, true, this.invocationContext);
    }

    public void removeRedirectUri(String redirectUri) {
        this.getMongoStore().pullItemFromList(this.clientEntity, "redirectUris", (Object)redirectUri, this.invocationContext);
    }

    public boolean isEnabled() {
        return this.getMongoEntityAsClient().isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.getMongoEntityAsClient().setEnabled(enabled);
        this.updateMongoEntity();
    }

    public boolean validateSecret(String secret) {
        return secret.equals(this.getMongoEntityAsClient().getSecret());
    }

    public String getSecret() {
        return this.getMongoEntityAsClient().getSecret();
    }

    public void setSecret(String secret) {
        this.getMongoEntityAsClient().setSecret(secret);
        this.updateMongoEntity();
    }

    public boolean isPublicClient() {
        return this.getMongoEntityAsClient().isPublicClient();
    }

    public void setPublicClient(boolean flag) {
        this.getMongoEntityAsClient().setPublicClient(flag);
        this.updateMongoEntity();
    }

    public boolean isFrontchannelLogout() {
        return this.getMongoEntityAsClient().isFrontchannelLogout();
    }

    public void setFrontchannelLogout(boolean flag) {
        this.getMongoEntityAsClient().setFrontchannelLogout(flag);
        this.updateMongoEntity();
    }

    public boolean isFullScopeAllowed() {
        return this.getMongoEntityAsClient().isFullScopeAllowed();
    }

    public void setFullScopeAllowed(boolean value) {
        this.getMongoEntityAsClient().setFullScopeAllowed(value);
        this.updateMongoEntity();
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public int getNotBefore() {
        return this.getMongoEntityAsClient().getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.getMongoEntityAsClient().setNotBefore(notBefore);
        this.updateMongoEntity();
    }

    public Set<RoleModel> getScopeMappings() {
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        List<MongoRoleEntity> roles = MongoModelUtils.getAllScopesOfClient(this, this.invocationContext);
        for (MongoRoleEntity role : roles) {
            if (this.realm.getId().equals(role.getRealmId())) {
                result.add(new RoleAdapter(this.session, this.realm, role, (RoleContainerModel)this.realm, this.invocationContext));
                continue;
            }
            result.add(new RoleAdapter(this.session, this.realm, role, this.invocationContext));
        }
        return result;
    }

    public Set<RoleModel> getRealmScopeMappings() {
        Set<RoleModel> allScopes = this.getScopeMappings();
        HashSet<RoleModel> realmRoles = new HashSet<RoleModel>();
        for (RoleModel role : allScopes) {
            MongoRoleEntity roleEntity = ((RoleAdapter)role).getRole();
            if (!this.realm.getId().equals(roleEntity.getRealmId())) continue;
            realmRoles.add(role);
        }
        return realmRoles;
    }

    public boolean hasScope(RoleModel role) {
        if (this.isFullScopeAllowed()) {
            return true;
        }
        Set<RoleModel> roles = this.getScopeMappings();
        if (roles.contains(role)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public void addScopeMapping(RoleModel role) {
        this.getMongoStore().pushItemToList(this.getMongoEntity(), "scopeIds", (Object)role.getId(), true, this.invocationContext);
    }

    public void deleteScopeMapping(RoleModel role) {
        this.getMongoStore().pullItemFromList(this.getMongoEntity(), "scopeIds", (Object)role.getId(), this.invocationContext);
    }

    public String getProtocol() {
        return this.getMongoEntityAsClient().getProtocol();
    }

    public void setProtocol(String protocol) {
        this.getMongoEntityAsClient().setProtocol(protocol);
        this.updateMongoEntity();
    }

    public void setAttribute(String name, String value) {
        this.getMongoEntityAsClient().getAttributes().put(name, value);
        this.updateMongoEntity();
    }

    public void removeAttribute(String name) {
        this.getMongoEntityAsClient().getAttributes().remove(name);
        this.updateMongoEntity();
    }

    public String getAttribute(String name) {
        return (String)this.getMongoEntityAsClient().getAttributes().get(name);
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> copy = new HashMap<String, String>();
        copy.putAll(this.getMongoEntityAsClient().getAttributes());
        return copy;
    }

    public Set<ProtocolMapperModel> getProtocolMappers() {
        HashSet<ProtocolMapperModel> result = new HashSet<ProtocolMapperModel>();
        for (ProtocolMapperEntity entity : this.getMongoEntityAsClient().getProtocolMappers()) {
            ProtocolMapperModel mapping = new ProtocolMapperModel();
            mapping.setId(entity.getId());
            mapping.setName(entity.getName());
            mapping.setProtocol(entity.getProtocol());
            mapping.setProtocolMapper(entity.getProtocolMapper());
            mapping.setConsentRequired(entity.isConsentRequired());
            mapping.setConsentText(entity.getConsentText());
            HashMap config = new HashMap();
            if (entity.getConfig() != null) {
                config.putAll(entity.getConfig());
            }
            mapping.setConfig(config);
            result.add(mapping);
        }
        return result;
    }

    public ProtocolMapperModel addProtocolMapper(ProtocolMapperModel model) {
        if (this.getProtocolMapperByName(model.getProtocol(), model.getName()) != null) {
            throw new RuntimeException("protocol mapper name must be unique per protocol");
        }
        ProtocolMapperEntity entity = new ProtocolMapperEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setProtocol(model.getProtocol());
        entity.setName(model.getName());
        entity.setProtocolMapper(model.getProtocolMapper());
        entity.setConfig(model.getConfig());
        entity.setConsentRequired(model.isConsentRequired());
        entity.setConsentText(model.getConsentText());
        this.getMongoEntityAsClient().getProtocolMappers().add(entity);
        this.updateMongoEntity();
        return this.entityToModel(entity);
    }

    public void removeProtocolMapper(ProtocolMapperModel mapping) {
        for (ProtocolMapperEntity entity : this.getMongoEntityAsClient().getProtocolMappers()) {
            if (!entity.getId().equals(mapping.getId())) continue;
            this.getMongoEntityAsClient().getProtocolMappers().remove(entity);
            this.updateMongoEntity();
            break;
        }
    }

    protected ProtocolMapperEntity getProtocolMapperyEntityById(String id) {
        for (ProtocolMapperEntity entity : this.getMongoEntityAsClient().getProtocolMappers()) {
            if (!entity.getId().equals(id)) continue;
            return entity;
        }
        return null;
    }

    protected ProtocolMapperEntity getProtocolMapperEntityByName(String protocol, String name) {
        for (ProtocolMapperEntity entity : this.getMongoEntityAsClient().getProtocolMappers()) {
            if (!entity.getProtocol().equals(protocol) || !entity.getName().equals(name)) continue;
            return entity;
        }
        return null;
    }

    public void updateProtocolMapper(ProtocolMapperModel mapping) {
        ProtocolMapperEntity entity = this.getProtocolMapperyEntityById(mapping.getId());
        entity.setProtocolMapper(mapping.getProtocolMapper());
        entity.setConsentRequired(mapping.isConsentRequired());
        entity.setConsentText(mapping.getConsentText());
        if (entity.getConfig() != null) {
            entity.getConfig().clear();
            entity.getConfig().putAll(mapping.getConfig());
        } else {
            entity.setConfig(mapping.getConfig());
        }
        this.updateMongoEntity();
    }

    public ProtocolMapperModel getProtocolMapperById(String id) {
        ProtocolMapperEntity entity = this.getProtocolMapperyEntityById(id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public ProtocolMapperModel getProtocolMapperByName(String protocol, String name) {
        ProtocolMapperEntity entity = this.getProtocolMapperEntityByName(protocol, name);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    protected ProtocolMapperModel entityToModel(ProtocolMapperEntity entity) {
        ProtocolMapperModel mapping = new ProtocolMapperModel();
        mapping.setId(entity.getId());
        mapping.setName(entity.getName());
        mapping.setProtocol(entity.getProtocol());
        mapping.setProtocolMapper(entity.getProtocolMapper());
        mapping.setConsentRequired(entity.isConsentRequired());
        mapping.setConsentText(entity.getConsentText());
        HashMap config = new HashMap();
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        mapping.setConfig(config);
        return mapping;
    }

    public void updateIdentityProviders(List<ClientIdentityProviderMappingModel> identityProviders) {
        ArrayList<ClientIdentityProviderMappingEntity> stored = new ArrayList<ClientIdentityProviderMappingEntity>();
        for (ClientIdentityProviderMappingModel model : identityProviders) {
            ClientIdentityProviderMappingEntity entity = new ClientIdentityProviderMappingEntity();
            entity.setId(model.getIdentityProvider());
            entity.setRetrieveToken(model.isRetrieveToken());
            stored.add(entity);
        }
        this.getMongoEntityAsClient().setIdentityProviders(stored);
        this.updateMongoEntity();
    }

    public List<ClientIdentityProviderMappingModel> getIdentityProviders() {
        ArrayList<ClientIdentityProviderMappingModel> models = new ArrayList<ClientIdentityProviderMappingModel>();
        for (ClientIdentityProviderMappingEntity entity : this.getMongoEntityAsClient().getIdentityProviders()) {
            ClientIdentityProviderMappingModel model = new ClientIdentityProviderMappingModel();
            model.setIdentityProvider(entity.getId());
            model.setRetrieveToken(entity.isRetrieveToken());
            models.add(model);
        }
        return models;
    }

    public boolean isAllowedRetrieveTokenFromIdentityProvider(String providerId) {
        for (ClientIdentityProviderMappingEntity identityProviderMappingModel : this.getMongoEntityAsClient().getIdentityProviders()) {
            if (!identityProviderMappingModel.getId().equals(providerId)) continue;
            return identityProviderMappingModel.isRetrieveToken();
        }
        return false;
    }
}

