/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.file.adapter;

import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.entities.ClientEntity;
import org.keycloak.models.entities.OAuthClientEntity;
import org.keycloak.models.file.adapter.ClientAdapter;
import org.keycloak.models.file.adapter.RealmAdapter;

public class OAuthClientAdapter
extends ClientAdapter
implements OAuthClientModel {
    private final OAuthClientEntity oauthClientEntity;

    public OAuthClientAdapter(KeycloakSession session, RealmModel realm, OAuthClientEntity oauthClientEntity) {
        super(session, realm, (ClientEntity)oauthClientEntity);
        this.oauthClientEntity = oauthClientEntity;
    }

    public String getName() {
        return this.oauthClientEntity.getName();
    }

    public void setClientId(String id) {
        if (id == null) {
            throw new NullPointerException("id == null");
        }
        if (this.oauthClientEntity.getName().equals(id)) {
            return;
        }
        RealmAdapter realmAdapter = (RealmAdapter)this.realm;
        if (realmAdapter.hasOAuthClientWithClientId(id)) {
            throw new ModelDuplicateException("Realm already has OAuthClient with client id " + id);
        }
        this.oauthClientEntity.setName(id);
    }

    public boolean isDirectGrantsOnly() {
        return this.oauthClientEntity.isDirectGrantsOnly();
    }

    public void setDirectGrantsOnly(boolean flag) {
        this.oauthClientEntity.setDirectGrantsOnly(flag);
    }
}

