/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.saml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.keycloak.ClientConnection;
import org.keycloak.VerificationException;
import org.keycloak.broker.provider.FederatedIdentity;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.saml.SAMLIdentityProviderConfig;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.saml.SAML2LogoutResponseBuilder;
import org.keycloak.protocol.saml.SAMLRequestParser;
import org.keycloak.protocol.saml.SamlProtocolUtils;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.resources.flows.Flows;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.DocumentUtil;
import org.picketlink.common.util.StaxParserUtil;
import org.picketlink.identity.federation.api.saml.v2.response.SAML2Response;
import org.picketlink.identity.federation.core.parsers.saml.SAMLParser;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.picketlink.identity.federation.core.util.JAXPValidationUtil;
import org.picketlink.identity.federation.core.util.XMLEncryptionUtil;
import org.picketlink.identity.federation.core.util.XMLSignatureUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.EncryptedAssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;
import org.picketlink.identity.federation.saml.v2.protocol.LogoutRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLEndpoint {
    protected static final Logger logger = Logger.getLogger(SAMLEndpoint.class);
    public static final String SAML_FEDERATED_SESSION_INDEX = "SAML_FEDERATED_SESSION_INDEX";
    public static final String SAML_FEDERATED_SUBJECT = "SAML_FEDERATED_SUBJECT";
    public static final String SAML_FEDERATED_SUBJECT_NAMEFORMAT = "SAML_FEDERATED_SUBJECT_NAMEFORMAT";
    protected RealmModel realm;
    protected EventBuilder event;
    protected SAMLIdentityProviderConfig config;
    protected IdentityProvider.AuthenticationCallback callback;
    @Context
    private UriInfo uriInfo;
    @Context
    private KeycloakSession session;
    @Context
    private ClientConnection clientConnection;
    @Context
    private HttpHeaders headers;

    public SAMLEndpoint(RealmModel realm, SAMLIdentityProviderConfig config, IdentityProvider.AuthenticationCallback callback) {
        this.realm = realm;
        this.config = config;
        this.callback = callback;
    }

    @GET
    public Response redirectBinding(@QueryParam(value="SAMLRequest") String samlRequest, @QueryParam(value="SAMLResponse") String samlResponse, @QueryParam(value="RelayState") String relayState) {
        return new RedirectBinding().execute(samlRequest, samlResponse, relayState);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response postBinding(@FormParam(value="SAMLRequest") String samlRequest, @FormParam(value="SAMLResponse") String samlResponse, @FormParam(value="RelayState") String relayState) {
        return new PostBinding().execute(samlRequest, samlResponse, relayState);
    }

    protected class RedirectBinding
    extends Binding {
        protected RedirectBinding() {
        }

        @Override
        protected void verifySignature(SAMLDocumentHolder documentHolder) throws VerificationException {
            PublicKey publicKey = this.getIDPKey();
            SamlProtocolUtils.verifyRedirectSignature((PublicKey)publicKey, (UriInfo)SAMLEndpoint.this.uriInfo);
        }

        @Override
        protected SAMLDocumentHolder extractRequestDocument(String samlRequest) {
            return SAMLRequestParser.parseRequestRedirectBinding((String)samlRequest);
        }

        @Override
        protected SAMLDocumentHolder extractResponseDocument(String response) {
            return SAMLRequestParser.parseRequestRedirectBinding((String)response);
        }

        @Override
        protected String getBindingType() {
            return "get";
        }
    }

    protected class PostBinding
    extends Binding {
        protected PostBinding() {
        }

        @Override
        protected void verifySignature(SAMLDocumentHolder documentHolder) throws VerificationException {
            SamlProtocolUtils.verifyDocumentSignature((Document)documentHolder.getSamlDocument(), (PublicKey)this.getIDPKey());
        }

        @Override
        protected SAMLDocumentHolder extractRequestDocument(String samlRequest) {
            return SAMLRequestParser.parseRequestPostBinding((String)samlRequest);
        }

        @Override
        protected SAMLDocumentHolder extractResponseDocument(String response) {
            return SAMLRequestParser.parseResponsePostBinding((String)response);
        }

        @Override
        protected String getBindingType() {
            return "post";
        }
    }

    protected abstract class Binding {
        protected Binding() {
        }

        private boolean checkSsl() {
            if (SAMLEndpoint.this.uriInfo.getBaseUri().getScheme().equals("https")) {
                return true;
            }
            return !SAMLEndpoint.this.realm.getSslRequired().isRequired(SAMLEndpoint.this.clientConnection);
        }

        protected Response basicChecks(String samlRequest, String samlResponse) {
            if (!this.checkSsl()) {
                SAMLEndpoint.this.event.event(EventType.LOGIN);
                SAMLEndpoint.this.event.error("ssl_required");
                return Flows.forwardToSecurityFailurePage((KeycloakSession)SAMLEndpoint.this.session, (RealmModel)SAMLEndpoint.this.realm, (UriInfo)SAMLEndpoint.this.uriInfo, (HttpHeaders)SAMLEndpoint.this.headers, (String)"httpsRequiredMessage", (Object[])new Object[0]);
            }
            if (!SAMLEndpoint.this.realm.isEnabled()) {
                SAMLEndpoint.this.event.event(EventType.LOGIN_ERROR);
                SAMLEndpoint.this.event.error("realm_disabled");
                return Flows.forwardToSecurityFailurePage((KeycloakSession)SAMLEndpoint.this.session, (RealmModel)SAMLEndpoint.this.realm, (UriInfo)SAMLEndpoint.this.uriInfo, (HttpHeaders)SAMLEndpoint.this.headers, (String)"realmNotEnabledMessage", (Object[])new Object[0]);
            }
            if (samlRequest == null && samlResponse == null) {
                SAMLEndpoint.this.event.event(EventType.LOGIN);
                SAMLEndpoint.this.event.error("invalid_request");
                return Flows.forwardToSecurityFailurePage((KeycloakSession)SAMLEndpoint.this.session, (RealmModel)SAMLEndpoint.this.realm, (UriInfo)SAMLEndpoint.this.uriInfo, (HttpHeaders)SAMLEndpoint.this.headers, (String)"invalidRequestMessage", (Object[])new Object[0]);
            }
            return null;
        }

        protected abstract String getBindingType();

        protected abstract void verifySignature(SAMLDocumentHolder var1) throws VerificationException;

        protected abstract SAMLDocumentHolder extractRequestDocument(String var1);

        protected abstract SAMLDocumentHolder extractResponseDocument(String var1);

        protected PublicKey getIDPKey() {
            X509Certificate certificate = null;
            try {
                certificate = XMLSignatureUtil.getX509CertificateFromKeyInfoString((String)SAMLEndpoint.this.config.getSigningCertificate().replaceAll("\\s", ""));
            }
            catch (ProcessingException e) {
                throw new RuntimeException(e);
            }
            return certificate.getPublicKey();
        }

        public Response execute(String samlRequest, String samlResponse, String relayState) {
            SAMLEndpoint.this.event = new EventBuilder(SAMLEndpoint.this.realm, SAMLEndpoint.this.session, SAMLEndpoint.this.clientConnection);
            Response response = this.basicChecks(samlRequest, samlResponse);
            if (response != null) {
                return response;
            }
            if (samlRequest != null) {
                return this.handleSamlRequest(samlRequest, relayState);
            }
            return this.handleSamlResponse(samlResponse, relayState);
        }

        protected Response handleSamlRequest(String samlRequest, String relayState) {
            SAMLDocumentHolder holder = this.extractRequestDocument(samlRequest);
            RequestAbstractType requestAbstractType = (RequestAbstractType)holder.getSamlObject();
            if (!SAMLEndpoint.this.uriInfo.getAbsolutePath().equals(requestAbstractType.getDestination())) {
                SAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                SAMLEndpoint.this.event.error("invalid_saml_response");
                SAMLEndpoint.this.event.detail("reason", "invalid_destination");
                return Flows.forwardToSecurityFailurePage((KeycloakSession)SAMLEndpoint.this.session, (RealmModel)SAMLEndpoint.this.realm, (UriInfo)SAMLEndpoint.this.uriInfo, (HttpHeaders)SAMLEndpoint.this.headers, (String)"invalidRequestMessage", (Object[])new Object[0]);
            }
            if (SAMLEndpoint.this.config.isValidateSignature()) {
                try {
                    this.verifySignature(holder);
                }
                catch (VerificationException e) {
                    logger.error((Object)"validation failed", (Throwable)e);
                    SAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    SAMLEndpoint.this.event.error("invalid_signature");
                    return Flows.forwardToSecurityFailurePage((KeycloakSession)SAMLEndpoint.this.session, (RealmModel)SAMLEndpoint.this.realm, (UriInfo)SAMLEndpoint.this.uriInfo, (HttpHeaders)SAMLEndpoint.this.headers, (String)"invalidRequesterMessage", (Object[])new Object[0]);
                }
            }
            if (requestAbstractType instanceof LogoutRequestType) {
                logger.debug((Object)"** logout request");
                SAMLEndpoint.this.event.event(EventType.LOGOUT);
                LogoutRequestType logout = (LogoutRequestType)requestAbstractType;
                return this.logoutRequest(logout, relayState);
            }
            SAMLEndpoint.this.event.event(EventType.LOGIN);
            SAMLEndpoint.this.event.error("invalid_token");
            return Flows.forwardToSecurityFailurePage((KeycloakSession)SAMLEndpoint.this.session, (RealmModel)SAMLEndpoint.this.realm, (UriInfo)SAMLEndpoint.this.uriInfo, (HttpHeaders)SAMLEndpoint.this.headers, (String)"invalidRequestMessage", (Object[])new Object[0]);
        }

        protected Response logoutRequest(LogoutRequestType request, String relayState) {
            String brokerUserId = SAMLEndpoint.this.config.getAlias() + "." + request.getNameID().getValue();
            if (request.getSessionIndex() == null || request.getSessionIndex().isEmpty()) {
                List userSessions = SAMLEndpoint.this.session.sessions().getUserSessionByBrokerUserId(SAMLEndpoint.this.realm, brokerUserId);
                for (UserSessionModel userSession : userSessions) {
                    try {
                        AuthenticationManager.backchannelLogout((KeycloakSession)SAMLEndpoint.this.session, (RealmModel)SAMLEndpoint.this.realm, (UserSessionModel)userSession, (UriInfo)SAMLEndpoint.this.uriInfo, (ClientConnection)SAMLEndpoint.this.clientConnection, (HttpHeaders)SAMLEndpoint.this.headers);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"failed to do backchannel logout for userSession", (Throwable)e);
                    }
                }
            } else {
                for (String sessionIndex : request.getSessionIndex()) {
                    String brokerSessionId = brokerUserId + "." + sessionIndex;
                    UserSessionModel userSession = SAMLEndpoint.this.session.sessions().getUserSessionByBrokerSessionId(SAMLEndpoint.this.realm, brokerSessionId);
                    if (userSession == null) continue;
                    try {
                        AuthenticationManager.backchannelLogout((KeycloakSession)SAMLEndpoint.this.session, (RealmModel)SAMLEndpoint.this.realm, (UserSessionModel)userSession, (UriInfo)SAMLEndpoint.this.uriInfo, (ClientConnection)SAMLEndpoint.this.clientConnection, (HttpHeaders)SAMLEndpoint.this.headers);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"failed to do backchannel logout for userSession", (Throwable)e);
                    }
                }
            }
            String issuerURL = this.getEntityId(SAMLEndpoint.this.uriInfo, SAMLEndpoint.this.realm);
            SAML2LogoutResponseBuilder builder = new SAML2LogoutResponseBuilder();
            builder.logoutRequestID(request.getID());
            builder.destination(SAMLEndpoint.this.config.getSingleLogoutServiceUrl());
            builder.issuer(issuerURL);
            builder.relayState(relayState);
            if (SAMLEndpoint.this.config.isWantAuthnRequestsSigned()) {
                ((SAML2LogoutResponseBuilder)builder.signWith(SAMLEndpoint.this.realm.getPrivateKey(), SAMLEndpoint.this.realm.getPublicKey(), SAMLEndpoint.this.realm.getCertificate())).signDocument();
            }
            try {
                if (SAMLEndpoint.this.config.isPostBindingResponse()) {
                    return builder.postBinding().response();
                }
                return builder.redirectBinding().response();
            }
            catch (ConfigurationException e) {
                throw new RuntimeException(e);
            }
            catch (ProcessingException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private String getEntityId(UriInfo uriInfo, RealmModel realm) {
            return UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("realms").path(realm.getName()).build(new Object[0]).toString();
        }

        protected Response handleLoginResponse(String samlResponse, SAMLDocumentHolder holder, ResponseType responseType, String relayState) {
            try {
                AssertionType assertion = this.getAssertion(responseType);
                SubjectType subject = assertion.getSubject();
                SubjectType.STSubType subType = subject.getSubType();
                NameIDType subjectNameID = (NameIDType)subType.getBaseID();
                HashMap<String, String> notes = new HashMap<String, String>();
                notes.put(SAMLEndpoint.SAML_FEDERATED_SUBJECT, subjectNameID.getValue());
                if (subjectNameID.getFormat() != null) {
                    notes.put(SAMLEndpoint.SAML_FEDERATED_SUBJECT_NAMEFORMAT, subjectNameID.getFormat().toString());
                }
                FederatedIdentity identity = new FederatedIdentity(subjectNameID.getValue());
                identity.setUsername(subjectNameID.getValue());
                if (subjectNameID.getFormat().toString().equals(JBossSAMLURIConstants.NAMEID_FORMAT_EMAIL.get())) {
                    identity.setEmail(subjectNameID.getValue());
                }
                if (SAMLEndpoint.this.config.isStoreToken()) {
                    identity.setToken(samlResponse);
                }
                AuthnStatementType authn = null;
                for (Object statement : assertion.getStatements()) {
                    if (!(statement instanceof AuthnStatementType)) continue;
                    authn = (AuthnStatementType)statement;
                    break;
                }
                String brokerUserId = SAMLEndpoint.this.config.getAlias() + "." + subjectNameID.getValue();
                identity.setBrokerUserId(brokerUserId);
                if (authn != null && authn.getSessionIndex() != null) {
                    identity.setBrokerSessionId(identity.getBrokerUserId() + "." + authn.getSessionIndex());
                    notes.put(SAMLEndpoint.SAML_FEDERATED_SESSION_INDEX, authn.getSessionIndex());
                }
                return SAMLEndpoint.this.callback.authenticated(notes, (IdentityProviderModel)SAMLEndpoint.this.config, identity, relayState);
            }
            catch (Exception e) {
                throw new IdentityBrokerException("Could not process response from SAML identity provider.", (Throwable)e);
            }
        }

        private AssertionType getAssertion(ResponseType responseType) throws ProcessingException {
            List assertions = responseType.getAssertions();
            if (assertions.isEmpty()) {
                throw new IdentityBrokerException("No assertion from response.");
            }
            ResponseType.RTChoiceType rtChoiceType = (ResponseType.RTChoiceType)assertions.get(0);
            EncryptedAssertionType encryptedAssertion = rtChoiceType.getEncryptedAssertion();
            if (encryptedAssertion != null) {
                this.decryptAssertion(responseType, SAMLEndpoint.this.realm.getPrivateKey());
            }
            return ((ResponseType.RTChoiceType)responseType.getAssertions().get(0)).getAssertion();
        }

        public Response handleSamlResponse(String samlResponse, String relayState) {
            SAMLDocumentHolder holder = this.extractResponseDocument(samlResponse);
            StatusResponseType statusResponse = (StatusResponseType)holder.getSamlObject();
            if (!SAMLEndpoint.this.uriInfo.getAbsolutePath().toString().equals(statusResponse.getDestination())) {
                SAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                SAMLEndpoint.this.event.error("invalid_saml_response");
                SAMLEndpoint.this.event.detail("reason", "invalid_destination");
                return Flows.forwardToSecurityFailurePage((KeycloakSession)SAMLEndpoint.this.session, (RealmModel)SAMLEndpoint.this.realm, (UriInfo)SAMLEndpoint.this.uriInfo, (HttpHeaders)SAMLEndpoint.this.headers, (String)"invalidFederatedIdentityActionMessage", (Object[])new Object[0]);
            }
            if (SAMLEndpoint.this.config.isValidateSignature()) {
                try {
                    this.verifySignature(holder);
                }
                catch (VerificationException e) {
                    logger.error((Object)"validation failed", (Throwable)e);
                    SAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    SAMLEndpoint.this.event.error("invalid_signature");
                    return Flows.forwardToSecurityFailurePage((KeycloakSession)SAMLEndpoint.this.session, (RealmModel)SAMLEndpoint.this.realm, (UriInfo)SAMLEndpoint.this.uriInfo, (HttpHeaders)SAMLEndpoint.this.headers, (String)"invalidFederatedIdentityActionMessage", (Object[])new Object[0]);
                }
            }
            if (statusResponse instanceof ResponseType) {
                return this.handleLoginResponse(samlResponse, holder, (ResponseType)statusResponse, relayState);
            }
            return this.handleLogoutResponse(holder, statusResponse, relayState);
        }

        protected Response handleLogoutResponse(SAMLDocumentHolder holder, StatusResponseType responseType, String relayState) {
            if (relayState == null) {
                logger.error((Object)"no valid user session");
                SAMLEndpoint.this.event.event(EventType.LOGOUT);
                SAMLEndpoint.this.event.error("user_session_not_found");
                return Flows.forwardToSecurityFailurePage((KeycloakSession)SAMLEndpoint.this.session, (RealmModel)SAMLEndpoint.this.realm, (UriInfo)SAMLEndpoint.this.uriInfo, (HttpHeaders)SAMLEndpoint.this.headers, (String)"identityProviderUnexpectedErrorMessage", (Object[])new Object[0]);
            }
            UserSessionModel userSession = SAMLEndpoint.this.session.sessions().getUserSession(SAMLEndpoint.this.realm, relayState);
            if (userSession == null) {
                logger.error((Object)"no valid user session");
                SAMLEndpoint.this.event.event(EventType.LOGOUT);
                SAMLEndpoint.this.event.error("user_session_not_found");
                return Flows.forwardToSecurityFailurePage((KeycloakSession)SAMLEndpoint.this.session, (RealmModel)SAMLEndpoint.this.realm, (UriInfo)SAMLEndpoint.this.uriInfo, (HttpHeaders)SAMLEndpoint.this.headers, (String)"identityProviderUnexpectedErrorMessage", (Object[])new Object[0]);
            }
            if (userSession.getState() != UserSessionModel.State.LOGGING_OUT) {
                logger.error((Object)"usersession in different state");
                SAMLEndpoint.this.event.event(EventType.LOGOUT);
                SAMLEndpoint.this.event.error("user_session_not_found");
                return Flows.forwardToSecurityFailurePage((KeycloakSession)SAMLEndpoint.this.session, (RealmModel)SAMLEndpoint.this.realm, (UriInfo)SAMLEndpoint.this.uriInfo, (HttpHeaders)SAMLEndpoint.this.headers, (String)"sessionNotActiveMessage", (Object[])new Object[0]);
            }
            return AuthenticationManager.finishBrowserLogout((KeycloakSession)SAMLEndpoint.this.session, (RealmModel)SAMLEndpoint.this.realm, (UserSessionModel)userSession, (UriInfo)SAMLEndpoint.this.uriInfo, (ClientConnection)SAMLEndpoint.this.clientConnection, (HttpHeaders)SAMLEndpoint.this.headers);
        }

        protected ResponseType decryptAssertion(ResponseType responseType, PrivateKey privateKey) throws ProcessingException {
            SAML2Response saml2Response = new SAML2Response();
            try {
                Document doc = saml2Response.convert((StatusResponseType)responseType);
                Element enc = DocumentUtil.getElement((Document)doc, (QName)new QName(JBossSAMLConstants.ENCRYPTED_ASSERTION.get()));
                if (enc == null) {
                    throw new IdentityBrokerException("No encrypted assertion found.");
                }
                String oldID = enc.getAttribute(JBossSAMLConstants.ID.get());
                Document newDoc = DocumentUtil.createDocument();
                Node importedNode = newDoc.importNode(enc, true);
                newDoc.appendChild(importedNode);
                Element decryptedDocumentElement = XMLEncryptionUtil.decryptElementInDocument((Document)newDoc, (PrivateKey)privateKey);
                SAMLParser parser = new SAMLParser();
                JAXPValidationUtil.checkSchemaValidation((Node)decryptedDocumentElement);
                AssertionType assertion = (AssertionType)parser.parse(StaxParserUtil.getXMLEventReader((InputStream)DocumentUtil.getNodeAsStream((Node)decryptedDocumentElement)));
                responseType.replaceAssertion(oldID, new ResponseType.RTChoiceType(assertion));
                return responseType;
            }
            catch (Exception e) {
                throw new IdentityBrokerException("Could not decrypt assertion.", (Throwable)e);
            }
        }
    }
}

