/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.file;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class InMemoryModel {
    private final Map<String, RealmModel> allRealms = new HashMap<String, RealmModel>();
    private final Map<String, Map<String, UserModel>> allUsers = new HashMap<String, Map<String, UserModel>>();

    public void putRealm(String id, RealmModel realm) {
        this.allRealms.put(id, realm);
        this.allUsers.put(id, new HashMap());
    }

    public RealmModel getRealm(String id) {
        return this.allRealms.get(id);
    }

    public Collection<RealmModel> getRealms() {
        return this.allRealms.values();
    }

    public RealmModel getRealmByName(String name) {
        for (RealmModel realm : this.getRealms()) {
            if (!realm.getName().equals(name)) continue;
            return realm;
        }
        return null;
    }

    public boolean removeRealm(String id) {
        this.allUsers.remove(id);
        return this.allRealms.remove(id) != null;
    }

    protected Map<String, UserModel> realmUsers(String realmId) {
        Map<String, UserModel> realmUsers = this.allUsers.get(realmId);
        if (realmUsers == null) {
            throw new NullPointerException("Realm users not found for id=" + realmId);
        }
        return realmUsers;
    }

    public void putUser(String realmId, String userId, UserModel user) {
        this.realmUsers(realmId).put(userId, user);
    }

    public UserModel getUser(String realmId, String userId) {
        return this.realmUsers(realmId).get(userId);
    }

    public boolean hasUserWithUsername(String realmId, String username) {
        for (UserModel user : this.getUsers(realmId)) {
            if (!user.getUsername().equals(username)) continue;
            return true;
        }
        return false;
    }

    public Collection<UserModel> getUsers(String realmId) {
        return this.realmUsers(realmId).values();
    }

    public boolean removeUser(String realmId, String userId) {
        return this.realmUsers(realmId).remove(userId) != null;
    }
}

