/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.net.URI;
import org.keycloak.protocol.saml.SAML2BindingBuilder;
import org.keycloak.protocol.saml.SAML2NameIDPolicyBuilder;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.identity.federation.api.saml.v2.request.SAML2Request;
import org.picketlink.identity.federation.core.saml.v2.common.IDGenerator;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.w3c.dom.Document;

public class SAML2AuthnRequestBuilder
extends SAML2BindingBuilder<SAML2AuthnRequestBuilder> {
    private final AuthnRequestType authnRequestType;

    public SAML2AuthnRequestBuilder() {
        try {
            this.authnRequestType = new AuthnRequestType(IDGenerator.create((String)"ID_"), XMLTimeUtil.getIssueInstant());
        }
        catch (ConfigurationException e) {
            throw new RuntimeException("Could not create SAML AuthnRequest builder.", e);
        }
    }

    public SAML2AuthnRequestBuilder assertionConsumerUrl(String assertionConsumerUrl) {
        this.authnRequestType.setAssertionConsumerServiceURL(URI.create(assertionConsumerUrl));
        return this;
    }

    public SAML2AuthnRequestBuilder forceAuthn(boolean forceAuthn) {
        this.authnRequestType.setForceAuthn(Boolean.valueOf(forceAuthn));
        return this;
    }

    public SAML2AuthnRequestBuilder nameIdPolicy(SAML2NameIDPolicyBuilder nameIDPolicy) {
        this.authnRequestType.setNameIDPolicy(nameIDPolicy.build());
        return this;
    }

    public SAML2AuthnRequestBuilder protocolBinding(String protocolBinding) {
        this.authnRequestType.setProtocolBinding(URI.create(protocolBinding));
        return this;
    }

    public SAML2BindingBuilder.RedirectBindingBuilder redirectBinding() {
        try {
            return new SAML2BindingBuilder.RedirectBindingBuilder(this, this.toDocument());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not build authn request for post binding.", e);
        }
    }

    public SAML2BindingBuilder.PostBindingBuilder postBinding() {
        try {
            return new SAML2BindingBuilder.PostBindingBuilder(this, this.toDocument());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not build authn request for post binding.", e);
        }
    }

    private Document toDocument() {
        try {
            AuthnRequestType authnRequestType = this.authnRequestType;
            NameIDType nameIDType = new NameIDType();
            nameIDType.setValue(this.issuer);
            authnRequestType.setIssuer(nameIDType);
            authnRequestType.setDestination(URI.create(this.destination));
            return new SAML2Request().convert((RequestAbstractType)authnRequestType);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not convert " + this.authnRequestType + " to a document.", e);
        }
    }
}

