/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.api.saml.v2.request.SAML2Request;
import org.picketlink.identity.federation.api.saml.v2.response.SAML2Response;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.picketlink.identity.federation.web.util.PostBindingUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingUtil;

public class SAMLRequestParser {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public static SAMLDocumentHolder parseRequestRedirectBinding(String samlMessage) {
        InputStream is = RedirectBindingUtil.base64DeflateDecode((String)samlMessage);
        SAML2Request saml2Request = new SAML2Request();
        try {
            saml2Request.getSAML2ObjectFromStream(is);
            return saml2Request.getSamlDocumentHolder();
        }
        catch (Exception e) {
            logger.samlBase64DecodingError((Throwable)e);
            return null;
        }
    }

    public static SAMLDocumentHolder parseRequestPostBinding(String samlMessage) {
        byte[] samlBytes = PostBindingUtil.base64Decode((String)samlMessage);
        ByteArrayInputStream is = new ByteArrayInputStream(samlBytes);
        SAML2Request saml2Request = new SAML2Request();
        try {
            saml2Request.getSAML2ObjectFromStream((InputStream)is);
            return saml2Request.getSamlDocumentHolder();
        }
        catch (Exception e) {
            logger.samlBase64DecodingError((Throwable)e);
            return null;
        }
    }

    public static SAMLDocumentHolder parseResponsePostBinding(String samlMessage) {
        byte[] samlBytes = PostBindingUtil.base64Decode((String)samlMessage);
        ByteArrayInputStream is = new ByteArrayInputStream(samlBytes);
        SAML2Response response = new SAML2Response();
        try {
            response.getSAML2ObjectFromStream((InputStream)is);
            return response.getSamlDocumentHolder();
        }
        catch (Exception e) {
            logger.samlBase64DecodingError((Throwable)e);
            return null;
        }
    }

    public static SAMLDocumentHolder parseResponseRedirectBinding(String samlMessage) {
        InputStream is = RedirectBindingUtil.base64DeflateDecode((String)samlMessage);
        SAML2Response response = new SAML2Response();
        try {
            response.getSAML2ObjectFromStream(is);
            return response.getSamlDocumentHolder();
        }
        catch (Exception e) {
            logger.samlBase64DecodingError((Throwable)e);
            return null;
        }
    }
}

