/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.mongo.updater.impl.updates;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.List;
import java.util.Map;
import org.keycloak.Config;
import org.keycloak.connections.mongo.impl.types.MapMapper;
import org.keycloak.connections.mongo.updater.impl.updates.Update;
import org.keycloak.migration.MigrationProvider;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;

public class Update1_2_0_Beta1
extends Update {
    @Override
    public String getId() {
        return "1.2.0.Beta1";
    }

    @Override
    public void update(KeycloakSession session) {
        this.deleteEntries("clientSessions");
        this.deleteEntries("sessions");
        this.convertSocialToIdFedRealms();
        this.convertSocialToIdFedUsers();
        this.addAccessCodeLoginTimeout();
        this.addNewAdminRoles();
        this.addDefaultProtocolMappers(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertSocialToIdFedRealms() {
        DBCollection realms = this.db.getCollection("realms");
        try (DBCursor realmsCursor = realms.find();){
            while (realmsCursor.hasNext()) {
                BasicDBObject realm = (BasicDBObject)realmsCursor.next();
                boolean updateProfileOnInitialSocialLogin = realm.getBoolean("updateProfileOnInitialSocialLogin");
                BasicDBObject socialConfig = (BasicDBObject)realm.get("socialConfig");
                BasicDBList identityProviders = (BasicDBList)realm.get("identityProviders");
                if (identityProviders == null) {
                    identityProviders = new BasicDBList();
                    realm.put("identityProviders", (Object)identityProviders);
                }
                if (socialConfig != null) {
                    for (Map.Entry entry : socialConfig.entrySet()) {
                        if (!((String)entry.getKey()).endsWith("###key")) continue;
                        String socialProviderId = ((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf("###"));
                        String clientId = (String)entry.getValue();
                        String clientSecret = socialConfig.getString(socialProviderId + "###secret");
                        DBObject identityProviderConfig = new BasicDBObjectBuilder().add("clientId", (Object)clientId).add("clientSecret", (Object)clientSecret).get();
                        DBObject identityProvider = new BasicDBObjectBuilder().add("internalId", (Object)KeycloakModelUtils.generateId()).add("providerId", (Object)socialProviderId).add("alias", (Object)socialProviderId).add("updateProfileFirstLogin", (Object)updateProfileOnInitialSocialLogin).add("enabled", (Object)true).add("storeToken", (Object)false).add("authenticateByDefault", (Object)false).add("config", (Object)identityProviderConfig).get();
                        identityProviders.add((Object)identityProvider);
                        this.log.debugv("Converted social provider {0} to identity provider", (Object)socialProviderId);
                    }
                }
                realm.remove((Object)"social");
                realm.remove((Object)"updateProfileOnInitialSocialLogin");
                realm.remove((Object)"socialConfig");
                realms.save((DBObject)realm);
                this.log.debugv("Social providers of realm {0} converted to identity providers", realm.get("_id"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertSocialToIdFedUsers() {
        DBCollection users = this.db.getCollection("users");
        try (DBCursor usersCursor = users.find();){
            while (usersCursor.hasNext()) {
                BasicDBObject user = (BasicDBObject)usersCursor.next();
                BasicDBList socialLinks = (BasicDBList)user.get("socialLinks");
                if (socialLinks == null) continue;
                BasicDBList federatedIdentities = (BasicDBList)user.get("federatedIdentities");
                if (federatedIdentities == null) {
                    federatedIdentities = new BasicDBList();
                    user.put("federatedIdentities", (Object)federatedIdentities);
                }
                for (Object socialLinkObj : socialLinks) {
                    BasicDBObject socialLink = (BasicDBObject)socialLinkObj;
                    BasicDBObject idFedLink = new BasicDBObject();
                    idFedLink.put("userName", socialLink.get("socialUsername"));
                    idFedLink.put("userId", socialLink.get("socialUserId"));
                    idFedLink.put("identityProvider", socialLink.get("socialProvider"));
                    federatedIdentities.add((Object)idFedLink);
                }
                user.remove((Object)"socialLinks");
                users.save((DBObject)user);
                if (!this.log.isTraceEnabled()) continue;
                this.log.tracev("Social links of user {0} converted to identity links", user.get("_id"));
            }
        }
        this.log.debug((Object)"Social links of users converted to identity links");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAccessCodeLoginTimeout() {
        DBCollection realms = this.db.getCollection("realms");
        try (DBCursor realmsCursor = realms.find();){
            while (realmsCursor.hasNext()) {
                BasicDBObject realm = (BasicDBObject)realmsCursor.next();
                realm.put("accessCodeLifespanLogin", (Object)1800);
                realms.save((DBObject)realm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewAdminRoles() {
        DBCollection realms = this.db.getCollection("realms");
        String adminRealmName = Config.getAdminRealm();
        try (DBCursor realmsCursor = realms.find();){
            while (realmsCursor.hasNext()) {
                BasicDBObject realm = (BasicDBObject)realmsCursor.next();
                if (adminRealmName.equals(realm.get("name"))) {
                    this.addNewAdminRolesToMasterRealm(realm);
                    continue;
                }
                this.addNewAdminRolesToRealm(realm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewAdminRolesToMasterRealm(BasicDBObject adminRealm) {
        DBCollection realms = this.db.getCollection("realms");
        DBCollection applications = this.db.getCollection("applications");
        DBCollection roles = this.db.getCollection("roles");
        try (DBCursor realmsCursor = realms.find();){
            while (realmsCursor.hasNext()) {
                BasicDBObject currentRealm = (BasicDBObject)realmsCursor.next();
                String masterAdminAppName = currentRealm.getString("name") + "-realm";
                BasicDBObject masterAdminApp = (BasicDBObject)applications.findOne((DBObject)new BasicDBObject().append("realmId", adminRealm.get("_id")).append("name", (Object)masterAdminAppName));
                String viewIdProvidersRoleId = this.insertApplicationRole(roles, AdminRoles.VIEW_IDENTITY_PROVIDERS, masterAdminApp.getString("_id"));
                String manageIdProvidersRoleId = this.insertApplicationRole(roles, AdminRoles.MANAGE_IDENTITY_PROVIDERS, masterAdminApp.getString("_id"));
                BasicDBObject adminRole = (BasicDBObject)roles.findOne((DBObject)new BasicDBObject().append("realmId", adminRealm.get("_id")).append("name", (Object)AdminRoles.ADMIN));
                BasicDBList adminCompositeRoles = (BasicDBList)adminRole.get("compositeRoleIds");
                adminCompositeRoles.add((Object)viewIdProvidersRoleId);
                adminCompositeRoles.add((Object)manageIdProvidersRoleId);
                roles.save((DBObject)adminRole);
                this.log.debugv("Added roles {0} and {1} to application {2}", (Object)AdminRoles.VIEW_IDENTITY_PROVIDERS, (Object)AdminRoles.MANAGE_IDENTITY_PROVIDERS, (Object)masterAdminAppName);
            }
        }
    }

    private void addNewAdminRolesToRealm(BasicDBObject currentRealm) {
        DBCollection applications = this.db.getCollection("applications");
        DBCollection roles = this.db.getCollection("roles");
        BasicDBObject adminApp = (BasicDBObject)applications.findOne((DBObject)new BasicDBObject().append("realmId", currentRealm.get("_id")).append("name", (Object)"realm-management"));
        String viewIdProvidersRoleId = this.insertApplicationRole(roles, AdminRoles.VIEW_IDENTITY_PROVIDERS, adminApp.getString("_id"));
        String manageIdProvidersRoleId = this.insertApplicationRole(roles, AdminRoles.MANAGE_IDENTITY_PROVIDERS, adminApp.getString("_id"));
        BasicDBObject adminRole = (BasicDBObject)roles.findOne((DBObject)new BasicDBObject().append("applicationId", adminApp.get("_id")).append("name", (Object)AdminRoles.REALM_ADMIN));
        BasicDBList adminCompositeRoles = (BasicDBList)adminRole.get("compositeRoleIds");
        adminCompositeRoles.add((Object)viewIdProvidersRoleId);
        adminCompositeRoles.add((Object)manageIdProvidersRoleId);
        roles.save((DBObject)adminRole);
        this.log.debugv("Added roles {0} and {1} to application realm-management of realm {2}", (Object)AdminRoles.VIEW_IDENTITY_PROVIDERS, (Object)AdminRoles.MANAGE_IDENTITY_PROVIDERS, currentRealm.get("name"));
    }

    private void addDefaultProtocolMappers(KeycloakSession session) {
        this.addDefaultMappers(session, this.db.getCollection("applications"));
        this.addDefaultMappers(session, this.db.getCollection("oauthClients"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDefaultMappers(KeycloakSession session, DBCollection clients) {
        try (DBCursor clientsCursor = clients.find();){
            while (clientsCursor.hasNext()) {
                BasicDBObject currentClient = (BasicDBObject)clientsCursor.next();
                BasicDBList dbProtocolMappers = new BasicDBList();
                currentClient.put("protocolMappers", (Object)dbProtocolMappers);
                Object claimMask = currentClient.get("allowedClaimsMask");
                MigrationProvider migrationProvider = (MigrationProvider)session.getProvider(MigrationProvider.class);
                List protocolMappers = migrationProvider.getMappersForClaimMask((Long)claimMask);
                for (ProtocolMapperRepresentation protocolMapper : protocolMappers) {
                    BasicDBObject dbMapper = new BasicDBObject();
                    dbMapper.put("id", (Object)KeycloakModelUtils.generateId());
                    dbMapper.put("protocol", (Object)protocolMapper.getProtocol());
                    dbMapper.put("name", (Object)protocolMapper.getName());
                    dbMapper.put("consentRequired", (Object)protocolMapper.isConsentRequired());
                    dbMapper.put("consentText", (Object)protocolMapper.getConsentText());
                    dbMapper.put("protocolMapper", (Object)protocolMapper.getProtocolMapper());
                    Map config = protocolMapper.getConfig();
                    BasicDBObject dbConfig = MapMapper.convertMap((Map)config);
                    dbMapper.put("config", (Object)dbConfig);
                    dbProtocolMappers.add((Object)dbMapper);
                }
                currentClient.remove((Object)"allowedClaimsMask");
                this.log.debugv("Added default mappers to application {1}", currentClient.get("name"));
                clients.save((DBObject)currentClient);
            }
        }
    }
}

