/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.extension.authserver;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.keycloak.subsystem.extension.KeycloakAdapterConfigService;
import org.keycloak.subsystem.extension.authserver.AuthServerUtil;

public final class AuthServerRemoveHandler
extends AbstractRemoveStepHandler {
    public static AuthServerRemoveHandler INSTANCE = new AuthServerRemoveHandler();

    private AuthServerRemoveHandler() {
    }

    protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String deploymentName = AuthServerUtil.getDeploymentName(operation);
        KeycloakAdapterConfigService.getInstance().removeServerDeployment(deploymentName);
        if (this.requiresRuntime(context)) {
            this.addStepToRemoveAuthServer(context, deploymentName);
        }
        super.performRemove(context, operation, model);
    }

    private void addStepToRemoveAuthServer(OperationContext context, String deploymentName) {
        PathAddress deploymentAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment", (String)deploymentName)});
        ModelNode op = Util.createOperation((String)"remove", (PathAddress)deploymentAddress);
        context.addStep(op, this.getRemoveHandler(context, deploymentAddress), OperationContext.Stage.MODEL);
    }

    private OperationStepHandler getRemoveHandler(OperationContext context, PathAddress address) {
        ImmutableManagementResourceRegistration rootResourceRegistration = context.getRootResourceRegistration();
        return rootResourceRegistration.getOperationHandler(address, "remove");
    }
}

