/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport.zip;

import de.idyl.winzipaes.AesZipFileDecrypter;
import de.idyl.winzipaes.impl.AESDecrypter;
import de.idyl.winzipaes.impl.AESDecrypterBC;
import de.idyl.winzipaes.impl.ExtZipEntry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import org.codehaus.jackson.map.ObjectMapper;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.exportimport.ImportProvider;
import org.keycloak.exportimport.Strategy;
import org.keycloak.exportimport.util.ExportImportJob;
import org.keycloak.exportimport.util.ExportImportUtils;
import org.keycloak.exportimport.util.ImportUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.util.JsonSerialization;

public class ZipImportProvider
implements ImportProvider {
    private static final Logger logger = Logger.getLogger(ZipImportProvider.class);
    private final AesZipFileDecrypter decrypter;
    private final String password;

    public ZipImportProvider(File zipFile, String password) {
        try {
            if (!zipFile.exists()) {
                throw new IllegalStateException("File " + zipFile.getAbsolutePath() + " doesn't exists");
            }
            AESDecrypterBC decrypter = new AESDecrypterBC();
            this.decrypter = new AesZipFileDecrypter(zipFile, (AESDecrypter)decrypter);
            this.password = password;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        logger.infof("Importing from ZIP file %s", (Object)zipFile.getAbsolutePath());
    }

    public void importModel(KeycloakSessionFactory factory, Strategy strategy) throws IOException {
        ArrayList<String> realmNames = new ArrayList<String>();
        for (ExtZipEntry entry : this.decrypter.getEntryList()) {
            String entryName = entry.getName();
            if (!entryName.endsWith("-realm.json")) continue;
            String realmName = entryName.substring(0, entryName.length() - 11);
            if (Config.getAdminRealm().equals(realmName)) {
                realmNames.add(0, realmName);
                continue;
            }
            realmNames.add(realmName);
        }
        for (String realmName : realmNames) {
            this.importRealm(factory, realmName, strategy);
        }
    }

    public void importRealm(KeycloakSessionFactory factory, final String realmName, final Strategy strategy) throws IOException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.decrypter.extractEntry(this.decrypter.getEntry(realmName + "-realm.json"), (OutputStream)bos, this.password);
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            final RealmRepresentation realmRep = (RealmRepresentation)JsonSerialization.mapper.readValue((InputStream)bis, RealmRepresentation.class);
            ExportImportUtils.runJobInTransaction((KeycloakSessionFactory)factory, (ExportImportJob)new ExportImportJob(){

                public void run(KeycloakSession session) throws IOException {
                    ImportUtils.importRealm((KeycloakSession)session, (RealmRepresentation)realmRep, (Strategy)strategy);
                }
            });
            for (ExtZipEntry entry : this.decrypter.getEntryList()) {
                String name = entry.getName();
                if (!name.startsWith(realmName) || !name.endsWith(".json") || !name.substring(realmName.length()).contains("-users-")) continue;
                bos = new ByteArrayOutputStream();
                this.decrypter.extractEntry(entry, (OutputStream)bos, this.password);
                final ByteArrayInputStream bis2 = new ByteArrayInputStream(bos.toByteArray());
                ExportImportUtils.runJobInTransaction((KeycloakSessionFactory)factory, (ExportImportJob)new ExportImportJob(){

                    public void run(KeycloakSession session) throws IOException {
                        ImportUtils.importUsersFromStream((KeycloakSession)session, (String)realmName, (ObjectMapper)JsonSerialization.mapper, (InputStream)bis2);
                    }
                });
            }
        }
        catch (DataFormatException dfe) {
            throw new RuntimeException(dfe);
        }
    }

    public void close() {
        try {
            this.decrypter.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

