/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak;

import java.security.PublicKey;
import org.keycloak.common.VerificationException;
import org.keycloak.jose.jws.JWSHeader;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.jose.jws.crypto.RSAProvider;
import org.keycloak.representations.AccessToken;

public class RSATokenVerifier {
    private final String tokenString;
    private PublicKey publicKey;
    private String realmUrl;
    private boolean checkTokenType = true;
    private boolean checkActive = true;
    private boolean checkRealmUrl = true;
    private JWSInput jws;
    private AccessToken token;

    private RSATokenVerifier(String tokenString) {
        this.tokenString = tokenString;
    }

    public static RSATokenVerifier create(String tokenString) {
        return new RSATokenVerifier(tokenString);
    }

    public static AccessToken verifyToken(String tokenString, PublicKey publicKey, String realmUrl) throws VerificationException {
        return RSATokenVerifier.create(tokenString).publicKey(publicKey).realmUrl(realmUrl).verify().getToken();
    }

    public static AccessToken verifyToken(String tokenString, PublicKey publicKey, String realmUrl, boolean checkActive, boolean checkTokenType) throws VerificationException {
        return RSATokenVerifier.create(tokenString).publicKey(publicKey).realmUrl(realmUrl).checkActive(checkActive).checkTokenType(checkTokenType).verify().getToken();
    }

    public RSATokenVerifier publicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public RSATokenVerifier realmUrl(String realmUrl) {
        this.realmUrl = realmUrl;
        return this;
    }

    public RSATokenVerifier checkTokenType(boolean checkTokenType) {
        this.checkTokenType = checkTokenType;
        return this;
    }

    public RSATokenVerifier checkActive(boolean checkActive) {
        this.checkActive = checkActive;
        return this;
    }

    public RSATokenVerifier checkRealmUrl(boolean checkRealmUrl) {
        this.checkRealmUrl = checkRealmUrl;
        return this;
    }

    public RSATokenVerifier parse() throws VerificationException {
        if (this.jws == null) {
            if (this.tokenString == null) {
                throw new VerificationException("Token not set");
            }
            try {
                this.jws = new JWSInput(this.tokenString);
            }
            catch (JWSInputException e) {
                throw new VerificationException("Failed to parse JWT", (Throwable)e);
            }
            try {
                this.token = this.jws.readJsonContent(AccessToken.class);
            }
            catch (JWSInputException e) {
                throw new VerificationException("Failed to read access token from JWT", (Throwable)e);
            }
        }
        return this;
    }

    public AccessToken getToken() throws VerificationException {
        this.parse();
        return this.token;
    }

    public JWSHeader getHeader() throws VerificationException {
        this.parse();
        return this.jws.getHeader();
    }

    public RSATokenVerifier verify() throws VerificationException {
        this.parse();
        if (this.publicKey == null) {
            throw new VerificationException("Public key not set");
        }
        if (this.checkRealmUrl && this.realmUrl == null) {
            throw new VerificationException("Realm URL not set");
        }
        if (!RSAProvider.verify(this.jws, this.publicKey)) {
            throw new VerificationException("Invalid token signature");
        }
        String user = this.token.getSubject();
        if (user == null) {
            throw new VerificationException("Subject missing in token");
        }
        if (this.checkRealmUrl && !this.realmUrl.equals(this.token.getIssuer())) {
            throw new VerificationException("Invalid token issuer. Expected '" + this.realmUrl + "', but was '" + this.token.getIssuer() + "'");
        }
        if (this.checkTokenType && !"Bearer".equalsIgnoreCase(this.token.getType())) {
            throw new VerificationException("Token type is incorrect. Expected 'Bearer' but was '" + this.token.getType() + "'");
        }
        if (this.checkActive && !this.token.isActive()) {
            throw new VerificationException("Token is not active");
        }
        return this;
    }
}

