/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.client.util;

import org.keycloak.authorization.client.AuthorizationDeniedException;
import org.keycloak.authorization.client.util.HttpResponseException;

public final class Throwables {
    public static RuntimeException handleAndWrapException(String message, Exception exception) {
        if (exception instanceof HttpResponseException) {
            throw Throwables.handleAndWrapHttpResponseException(message, (HttpResponseException)HttpResponseException.class.cast(exception));
        }
        return new RuntimeException(message, exception);
    }

    private static RuntimeException handleAndWrapHttpResponseException(String message, HttpResponseException exception) {
        HttpResponseException hre = (HttpResponseException)HttpResponseException.class.cast(exception);
        StringBuilder detail = new StringBuilder(message);
        byte[] bytes = hre.getBytes();
        if (bytes != null) {
            detail.append(". Server message: ").append(new String(bytes));
        }
        if (403 == exception.getStatusCode()) {
            throw new AuthorizationDeniedException(detail.toString(), exception);
        }
        return new RuntimeException(detail.toString(), exception);
    }
}

