/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.keycloak.AuthorizationContext;
import org.keycloak.common.util.Base64Url;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;
import org.keycloak.util.JsonSerialization;

public class KeycloakSecurityContext
implements Serializable {
    protected String tokenString;
    protected String idTokenString;
    protected transient AccessToken token;
    protected transient IDToken idToken;
    protected transient AuthorizationContext authorizationContext;

    public KeycloakSecurityContext() {
    }

    public KeycloakSecurityContext(String tokenString, AccessToken token, String idTokenString, IDToken idToken) {
        this.tokenString = tokenString;
        this.token = token;
        this.idToken = idToken;
        this.idTokenString = idTokenString;
    }

    public AccessToken getToken() {
        return this.token;
    }

    public String getTokenString() {
        return this.tokenString;
    }

    public AuthorizationContext getAuthorizationContext() {
        return this.authorizationContext;
    }

    public IDToken getIdToken() {
        return this.idToken;
    }

    public String getIdTokenString() {
        return this.idTokenString;
    }

    public String getRealm() {
        return this.token.getIssuer().substring(this.token.getIssuer().lastIndexOf(47) + 1);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.token = this.parseToken(this.tokenString, AccessToken.class);
        this.idToken = this.parseToken(this.idTokenString, IDToken.class);
    }

    private <T> T parseToken(String encoded, Class<T> clazz) throws IOException {
        if (encoded == null) {
            return null;
        }
        String[] parts = encoded.split("\\.");
        if (parts.length < 2 || parts.length > 3) {
            throw new IllegalArgumentException("Parsing error");
        }
        byte[] bytes = Base64Url.decode((String)parts[1]);
        return JsonSerialization.readValue(bytes, clazz);
    }
}

