/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.jboss.logging.Logger;
import org.keycloak.adapters.BearerTokenRequestAuthenticator;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OIDCAuthenticationError;
import org.keycloak.adapters.authentication.ClientCredentialsProviderUtils;
import org.keycloak.adapters.spi.AuthOutcome;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.common.util.Base64;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.util.JsonSerialization;

public class BasicAuthRequestAuthenticator
extends BearerTokenRequestAuthenticator {
    protected Logger log = Logger.getLogger(BasicAuthRequestAuthenticator.class);

    public BasicAuthRequestAuthenticator(KeycloakDeployment deployment) {
        super(deployment);
    }

    @Override
    public AuthOutcome authenticate(HttpFacade exchange) {
        List authHeaders = exchange.getRequest().getHeaders("Authorization");
        if (authHeaders == null || authHeaders.size() == 0) {
            this.challenge = this.challengeResponse(exchange, OIDCAuthenticationError.Reason.NO_AUTHORIZATION_HEADER, null, null);
            return AuthOutcome.NOT_ATTEMPTED;
        }
        this.tokenString = null;
        for (String authHeader : authHeaders) {
            String[] split = authHeader.trim().split("\\s+");
            if (split == null || split.length != 2 || !split[0].equalsIgnoreCase("Basic")) continue;
            this.tokenString = split[1];
        }
        if (this.tokenString == null) {
            this.challenge = this.challengeResponse(exchange, OIDCAuthenticationError.Reason.INVALID_TOKEN, null, null);
            return AuthOutcome.NOT_ATTEMPTED;
        }
        AccessTokenResponse atr = null;
        try {
            String userpw = new String(Base64.decode((String)this.tokenString));
            int seperatorIndex = userpw.indexOf(":");
            String user = userpw.substring(0, seperatorIndex);
            String pw = userpw.substring(seperatorIndex + 1);
            atr = this.getToken(user, pw);
            this.tokenString = atr.getToken();
        }
        catch (Exception e) {
            this.log.debug((Object)"Failed to obtain token", (Throwable)e);
            this.challenge = this.challengeResponse(exchange, OIDCAuthenticationError.Reason.INVALID_TOKEN, "no_token", e.getMessage());
            return AuthOutcome.FAILED;
        }
        return this.authenticateToken(exchange, atr.getToken());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccessTokenResponse getToken(String username, String password) throws Exception {
        AccessTokenResponse tokenResponse = null;
        HttpClient client = this.deployment.getClient();
        HttpPost post = new HttpPost(KeycloakUriBuilder.fromUri((String)this.deployment.getAuthServerBaseUrl()).path("/realms/{realm-name}/protocol/openid-connect/token").build(new Object[]{this.deployment.getRealm()}));
        ArrayList<NameValuePair> formparams = new ArrayList<NameValuePair>();
        formparams.add((NameValuePair)new BasicNameValuePair("grant_type", "password"));
        formparams.add((NameValuePair)new BasicNameValuePair("username", username));
        formparams.add((NameValuePair)new BasicNameValuePair("password", password));
        ClientCredentialsProviderUtils.setClientCredentials(this.deployment, post, formparams);
        UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, "UTF-8");
        post.setEntity((HttpEntity)form);
        HttpResponse response = client.execute((HttpUriRequest)post);
        int status = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        if (status != 200) {
            EntityUtils.consumeQuietly((HttpEntity)entity);
            throw new IOException("Bad status: " + status);
        }
        if (entity == null) {
            throw new IOException("No Entity");
        }
        InputStream is = entity.getContent();
        try {
            tokenResponse = (AccessTokenResponse)JsonSerialization.readValue((InputStream)is, AccessTokenResponse.class);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return tokenResponse;
    }
}

