/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.client.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.keycloak.authorization.client.Configuration;
import org.keycloak.authorization.client.representation.ResourceRepresentation;
import org.keycloak.authorization.client.representation.ServerConfiguration;
import org.keycloak.authorization.client.util.Http;
import org.keycloak.authorization.client.util.Throwables;
import org.keycloak.authorization.client.util.TokenCallable;
import org.keycloak.util.JsonSerialization;

public class ProtectedResource {
    private final Http http;
    private ServerConfiguration serverConfiguration;
    private final Configuration configuration;
    private final TokenCallable pat;

    ProtectedResource(Http http, ServerConfiguration serverConfiguration, Configuration configuration, TokenCallable pat) {
        this.http = http;
        this.serverConfiguration = serverConfiguration;
        this.configuration = configuration;
        this.pat = pat;
    }

    public ResourceRepresentation create(final ResourceRepresentation resource) {
        Callable<ResourceRepresentation> callable = new Callable<ResourceRepresentation>(){

            @Override
            public ResourceRepresentation call() throws Exception {
                return ProtectedResource.this.http.post(ProtectedResource.this.serverConfiguration.getResourceRegistrationEndpoint()).authorizationBearer(ProtectedResource.this.pat.call()).json(JsonSerialization.writeValueAsBytes((Object)resource)).response().json(ResourceRepresentation.class).execute();
            }
        };
        try {
            return (ResourceRepresentation)callable.call();
        }
        catch (Exception cause) {
            return Throwables.retryAndWrapExceptionIfNecessary(callable, this.pat, "Could not create resource", cause);
        }
    }

    public void update(final ResourceRepresentation resource) {
        if (resource.getId() == null) {
            throw new IllegalArgumentException("You must provide the resource id");
        }
        Callable callable = new Callable(){

            public Object call() throws Exception {
                ProtectedResource.this.http.put(ProtectedResource.this.serverConfiguration.getResourceRegistrationEndpoint() + "/" + resource.getId()).authorizationBearer(ProtectedResource.this.pat.call()).json(JsonSerialization.writeValueAsBytes((Object)resource)).execute();
                return null;
            }
        };
        try {
            callable.call();
        }
        catch (Exception cause) {
            Throwables.retryAndWrapExceptionIfNecessary(callable, this.pat, "Could not update resource", cause);
        }
    }

    public ResourceRepresentation findById(final String id) {
        Callable<ResourceRepresentation> callable = new Callable<ResourceRepresentation>(){

            @Override
            public ResourceRepresentation call() throws Exception {
                return ProtectedResource.this.http.get(ProtectedResource.this.serverConfiguration.getResourceRegistrationEndpoint() + "/" + id).authorizationBearer(ProtectedResource.this.pat.call()).response().json(ResourceRepresentation.class).execute();
            }
        };
        try {
            return (ResourceRepresentation)callable.call();
        }
        catch (Exception cause) {
            return Throwables.retryAndWrapExceptionIfNecessary(callable, this.pat, "Could not find resource", cause);
        }
    }

    public ResourceRepresentation findByName(String name) {
        String[] representations = this.find(null, name, null, this.configuration.getResource(), null, null, null, null);
        if (representations.length == 0) {
            return null;
        }
        return this.findById(representations[0]);
    }

    public ResourceRepresentation findByName(String name, String ownerId) {
        String[] representations = this.find(null, name, null, ownerId, null, null, null, null);
        if (representations.length == 0) {
            return null;
        }
        return this.findById(representations[0]);
    }

    public String[] find(final String id, final String name, final String uri, final String owner, final String type, final String scope, final Integer firstResult, final Integer maxResult) {
        Callable<String[]> callable = new Callable<String[]>(){

            @Override
            public String[] call() throws Exception {
                return ProtectedResource.this.http.get(ProtectedResource.this.serverConfiguration.getResourceRegistrationEndpoint()).authorizationBearer(ProtectedResource.this.pat.call()).param("_id", id).param("name", name).param("uri", uri).param("owner", owner).param("type", type).param("scope", scope).param("deep", Boolean.FALSE.toString()).param("first", firstResult != null ? firstResult.toString() : null).param("max", maxResult != null ? maxResult.toString() : null).response().json(String[].class).execute();
            }
        };
        try {
            return (String[])callable.call();
        }
        catch (Exception cause) {
            return Throwables.retryAndWrapExceptionIfNecessary(callable, this.pat, "Could not find resource", cause);
        }
    }

    public String[] findAll() {
        try {
            return this.find(null, null, null, null, null, null, null, null);
        }
        catch (Exception cause) {
            throw Throwables.handleWrapException("Could not find resource", cause);
        }
    }

    public void delete(final String id) {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                ProtectedResource.this.http.delete(ProtectedResource.this.serverConfiguration.getResourceRegistrationEndpoint() + "/" + id).authorizationBearer(ProtectedResource.this.pat.call()).execute();
                return null;
            }
        };
        try {
            callable.call();
        }
        catch (Exception cause) {
            Throwables.retryAndWrapExceptionIfNecessary(callable, this.pat, "", cause);
        }
    }

    public List<ResourceRepresentation> findByUri(String uri) {
        String[] ids = this.find(null, null, uri, null, null, null, null, null);
        if (ids.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ResourceRepresentation> representations = new ArrayList<ResourceRepresentation>();
        for (String id : ids) {
            representations.add(this.findById(id));
        }
        return representations;
    }
}

