/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.camel.undertow;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.component.undertow.RestUndertowHttpBinding;
import org.apache.camel.component.undertow.UndertowComponent;
import org.apache.camel.component.undertow.UndertowEndpoint;
import org.apache.camel.component.undertow.UndertowHttpBinding;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.HostUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.keycloak.adapters.camel.undertow.UndertowKeycloakEndpoint;

public class UndertowKeycloakComponent
extends UndertowComponent {
    public UndertowKeycloakComponent() {
    }

    public UndertowKeycloakComponent(CamelContext context) {
        super(context);
    }

    protected UndertowEndpoint createEndpointInstance(URI endpointUri, UndertowComponent component) throws URISyntaxException {
        return new UndertowKeycloakEndpoint(endpointUri.toString(), component);
    }

    protected String getComponentName() {
        return "undertow-keycloak";
    }

    public Consumer createConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.doCreateConsumer(camelContext, processor, verb, basePath, uriTemplate, consumes, produces, configuration, parameters, false);
    }

    public Consumer createApiConsumer(CamelContext camelContext, Processor processor, String contextPath, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.doCreateConsumer(camelContext, processor, "GET", contextPath, null, null, null, configuration, parameters, true);
    }

    Consumer doCreateConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters, boolean api) throws Exception {
        boolean cors;
        String contextPath;
        int num;
        String path = basePath;
        if (uriTemplate != null) {
            path = uriTemplate.startsWith("/") ? path + uriTemplate : path + "/" + uriTemplate;
        }
        path = FileUtil.stripLeadingSeparator((String)path);
        String scheme = "http";
        String host = "";
        int port = 0;
        RestConfiguration config = configuration;
        if (config == null) {
            config = camelContext.getRestConfiguration(this.getComponentName(), true);
        }
        if (config.getScheme() != null) {
            scheme = config.getScheme();
        }
        if (config.getHost() != null) {
            host = config.getHost();
        }
        if ((num = config.getPort()) > 0) {
            port = num;
        }
        if (ObjectHelper.isNotEmpty((Object)(contextPath = config.getContextPath()))) {
            contextPath = FileUtil.stripTrailingSeparator((String)contextPath);
            if (ObjectHelper.isNotEmpty((Object)(contextPath = FileUtil.stripLeadingSeparator((String)contextPath)))) {
                path = contextPath + "/" + path;
            }
        }
        if (ObjectHelper.isEmpty((Object)host)) {
            if (config.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.allLocalIp) {
                host = "0.0.0.0";
            } else if (config.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.localHostName) {
                host = HostUtils.getLocalHostName();
            } else if (config.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.localIp) {
                host = HostUtils.getLocalIp();
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if ((config.getComponent() == null || config.getComponent().equals(this.getComponentName())) && config.getEndpointProperties() != null && !config.getEndpointProperties().isEmpty()) {
            map.putAll(config.getEndpointProperties());
        }
        boolean explicitOptions = true;
        String restrict = verb.toUpperCase(Locale.US);
        if (!restrict.contains("OPTIONS")) {
            restrict = restrict + ",OPTIONS";
            explicitOptions = false;
        }
        if (cors = config.isEnableCORS()) {
            map.put("optionsEnabled", "true");
        } else if (explicitOptions) {
            map.put("optionsEnabled", "true");
        }
        String query = URISupport.createQueryString(map);
        String url = api ? this.getComponentName() + ":%s://%s:%s/%s?matchOnUriPrefix=true&httpMethodRestrict=%s" : this.getComponentName() + ":%s://%s:%s/%s?matchOnUriPrefix=false&httpMethodRestrict=%s";
        url = String.format(url, scheme, host, port, path, restrict);
        if (!query.isEmpty()) {
            url = url + "&" + query;
        }
        UndertowEndpoint endpoint = (UndertowEndpoint)camelContext.getEndpoint(url, UndertowEndpoint.class);
        this.setProperties(camelContext, endpoint, parameters);
        if (!map.containsKey("undertowHttpBinding")) {
            endpoint.setUndertowHttpBinding((UndertowHttpBinding)new RestUndertowHttpBinding());
        }
        Consumer consumer = endpoint.createConsumer(processor);
        if (config.getConsumerProperties() != null && !config.getConsumerProperties().isEmpty()) {
            this.setProperties(camelContext, consumer, config.getConsumerProperties());
        }
        return consumer;
    }
}

