/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.osgi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.keycloak.adapters.KeycloakConfigResolver;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.spi.HttpFacade;

public class PathBasedKeycloakConfigResolver
implements KeycloakConfigResolver {
    private final Map<String, KeycloakDeployment> cache = new ConcurrentHashMap<String, KeycloakDeployment>();

    public KeycloakDeployment resolve(HttpFacade.Request request) {
        String uri = request.getURI();
        String relativePath = request.getRelativePath();
        String webContext = null;
        if (relativePath == null || !uri.contains(relativePath)) {
            String[] urlTokens = uri.split("/");
            if (urlTokens.length < 4) {
                throw new IllegalStateException("Not able to determine the web-context to load the correspondent keycloak.json file");
            }
            webContext = urlTokens[3];
        } else {
            URI parsedURI = URI.create(uri);
            String path = parsedURI.getPath();
            path = path.substring(0, path.indexOf(relativePath));
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            webContext = path;
            if ("".equals(webContext)) {
                path = relativePath;
                while (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if (path.contains("/")) {
                    path = path.substring(0, path.indexOf("/"));
                }
                webContext = path;
            }
        }
        KeycloakDeployment deployment = this.cache.get(webContext);
        if (null == deployment) {
            String keycloakConfig = (String)System.getProperties().get("keycloak.config");
            if (keycloakConfig == null || "".equals(keycloakConfig.trim())) {
                String karafEtc = (String)System.getProperties().get("karaf.etc");
                if (karafEtc == null || "".equals(karafEtc.trim())) {
                    throw new IllegalStateException("Neither \"keycloak.config\" nor \"karaf.etc\" java properties are set. Please set one of them.");
                }
                keycloakConfig = karafEtc;
            }
            String absolutePath = keycloakConfig + File.separator + webContext + ("".equals(webContext) ? "" : "-") + "keycloak.json";
            FileInputStream is = null;
            try {
                is = new FileInputStream(absolutePath);
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Not able to find the file " + absolutePath);
            }
            deployment = KeycloakDeploymentBuilder.build((InputStream)is);
            this.cache.put(webContext, deployment);
        }
        return deployment;
    }
}

