/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.osgi;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.keycloak.adapters.KeycloakConfigResolver;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.spi.HttpFacade;

public class PathBasedKeycloakConfigResolver
implements KeycloakConfigResolver {
    protected static final Logger log = Logger.getLogger(PathBasedKeycloakConfigResolver.class);
    private final Map<String, KeycloakDeployment> cache = new ConcurrentHashMap<String, KeycloakDeployment>();
    private File keycloakConfigLocation = null;

    public PathBasedKeycloakConfigResolver() {
        File loc;
        String location = null;
        String keycloakConfig = (String)System.getProperties().get("keycloak.config");
        if (keycloakConfig != null && !"".equals(keycloakConfig.trim())) {
            location = keycloakConfig;
        } else {
            String karafEtc = (String)System.getProperties().get("karaf.etc");
            if (karafEtc != null && !"".equals(karafEtc.trim())) {
                location = karafEtc;
            }
        }
        if (location != null && (loc = new File(location)).isDirectory()) {
            this.keycloakConfigLocation = loc;
        }
    }

    public KeycloakDeployment resolve(HttpFacade.Request request) {
        String webContext = this.getDeploymentKeyForURI(request);
        return this.getOrCreateDeployment(webContext);
    }

    protected synchronized KeycloakDeployment getOrCreateDeployment(String pathFragment) {
        KeycloakDeployment deployment = this.getCachedDeployment(pathFragment);
        if (null == deployment) {
            if (this.keycloakConfigLocation == null) {
                throw new IllegalStateException("Neither \"keycloak.config\" nor \"karaf.etc\" java properties are set. Please set one of them.");
            }
            File configuration = new File(this.keycloakConfigLocation, pathFragment + ("".equals(pathFragment) ? "" : "-") + "keycloak.json");
            if (!this.cacheConfiguration(pathFragment, configuration)) {
                throw new IllegalStateException("Not able to read the file " + configuration);
            }
        }
        return deployment;
    }

    protected synchronized KeycloakDeployment getCachedDeployment(String pathFragment) {
        return this.cache.get(pathFragment);
    }

    protected void prepopulateCache() {
        if (this.keycloakConfigLocation == null || !this.keycloakConfigLocation.isDirectory()) {
            log.warn((Object)"Can't cache Keycloak configurations. No configuration storage is accessible. Please set either \"keycloak.config\" or \"karaf.etc\" system properties");
            return;
        }
        File[] configs = this.keycloakConfigLocation.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith("keycloak.json");
            }
        });
        if (configs != null) {
            for (File config : configs) {
                String pathFragment = null;
                if ("keycloak.json".equals(config.getName())) {
                    pathFragment = "";
                } else if (config.getName().endsWith("-keycloak.json")) {
                    pathFragment = config.getName().substring(0, config.getName().length() - "-keycloak.json".length());
                }
                this.cacheConfiguration(pathFragment, config);
            }
        }
    }

    private boolean cacheConfiguration(String key, File config) {
        try {
            FileInputStream is = new FileInputStream(config);
            KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((InputStream)is);
            this.cache.put(key, deployment);
            return true;
        }
        catch (FileNotFoundException | RuntimeException e) {
            log.warn((Object)("Can't cache " + config + ": " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    private String getDeploymentKeyForURI(HttpFacade.Request request) {
        String uri = request.getURI();
        String relativePath = request.getRelativePath();
        String webContext = null;
        if (relativePath == null || !uri.contains(relativePath)) {
            String[] urlTokens = uri.split("/");
            if (urlTokens.length < 4) {
                throw new IllegalStateException("Not able to determine the web-context to load the correspondent keycloak.json file");
            }
            webContext = urlTokens[3];
        } else {
            URI parsedURI = URI.create(uri);
            String path = parsedURI.getPath();
            if (path.contains(relativePath)) {
                path = path.substring(0, path.indexOf(relativePath));
            }
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            webContext = path;
            if ("".equals(webContext)) {
                path = relativePath;
                while (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if (path.contains("/")) {
                    path = path.substring(0, path.indexOf("/"));
                }
                webContext = path;
            }
        }
        return webContext;
    }
}

