/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.idm.authorization;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Permission {
    @JsonProperty(value="rsid")
    private String resourceId;
    @JsonProperty(value="rsname")
    private String resourceName;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Set<String> scopes;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final Map<String, Set<String>> claims;

    public Permission() {
        this(null, null, null, null);
    }

    public Permission(String resourceId, Set<String> scopes) {
        this(resourceId, null, scopes, null);
    }

    public Permission(String resourceId, String resourceName, Set<String> scopes, Map<String, Set<String>> claims) {
        this.resourceId = resourceId;
        this.resourceName = resourceName;
        this.scopes = scopes;
        this.claims = claims;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceId() {
        if (this.resourceId == null || "".equals(this.resourceId.trim())) {
            return null;
        }
        return this.resourceId;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public Set<String> getScopes() {
        if (this.scopes == null) {
            this.scopes = new HashSet<String>();
        }
        return this.scopes;
    }

    public Map<String, Set<String>> getClaims() {
        return this.claims;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().isAssignableFrom(o.getClass())) {
            return false;
        }
        Permission that = (Permission)o;
        if (this.getResourceId() != null || this.getResourceName() != null) {
            if (!this.getResourceId().equals(that.resourceId)) {
                return false;
            }
            if (this.getScopes().isEmpty() && that.getScopes().isEmpty()) {
                return true;
            }
        } else if (that.resourceId != null) {
            return false;
        }
        for (String scope : that.getScopes()) {
            if (!this.getScopes().contains(scope)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.resourceId);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Permission {").append("id=").append(this.resourceId).append(", name=").append(this.resourceName).append(", scopes=").append(this.scopes).append("}");
        return builder.toString();
    }

    public void setScopes(Set<String> scopes) {
        this.scopes = scopes;
    }
}

