/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.client.resource;

import java.util.concurrent.Callable;
import org.keycloak.authorization.client.AuthorizationDeniedException;
import org.keycloak.authorization.client.Configuration;
import org.keycloak.authorization.client.representation.ServerConfiguration;
import org.keycloak.authorization.client.util.Http;
import org.keycloak.authorization.client.util.HttpMethod;
import org.keycloak.authorization.client.util.Throwables;
import org.keycloak.authorization.client.util.TokenCallable;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.AuthorizationResponse;

public class AuthorizationResource {
    private Configuration configuration;
    private ServerConfiguration serverConfiguration;
    private Http http;
    private TokenCallable token;

    public AuthorizationResource(Configuration configuration, ServerConfiguration serverConfiguration, Http http, TokenCallable token) {
        this.configuration = configuration;
        this.serverConfiguration = serverConfiguration;
        this.http = http;
        this.token = token;
    }

    public AuthorizationResponse authorize() throws AuthorizationDeniedException {
        return this.authorize(new AuthorizationRequest());
    }

    public AuthorizationResponse authorize(final AuthorizationRequest request) throws AuthorizationDeniedException {
        if (request == null) {
            throw new IllegalArgumentException("Authorization request must not be null");
        }
        Callable<AuthorizationResponse> callable = new Callable<AuthorizationResponse>(){

            @Override
            public AuthorizationResponse call() throws Exception {
                request.setAudience(AuthorizationResource.this.configuration.getResource());
                HttpMethod method = AuthorizationResource.this.http.post(AuthorizationResource.this.serverConfiguration.getTokenEndpoint());
                if (AuthorizationResource.this.token != null) {
                    method = method.authorizationBearer(AuthorizationResource.this.token.call());
                }
                return method.authentication().uma(request).response().json(AuthorizationResponse.class).execute();
            }
        };
        try {
            return (AuthorizationResponse)callable.call();
        }
        catch (Exception cause) {
            return Throwables.retryAndWrapExceptionIfNecessary(callable, this.token, "Failed to obtain authorization data", cause);
        }
    }
}

