/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.keycloak.adapters.KeycloakConfigResolver;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.spi.HttpFacade;
import org.osgi.framework.BundleContext;

public class BundleBasedKeycloakConfigResolver
implements KeycloakConfigResolver {
    private volatile KeycloakDeployment cachedDeployment;
    private BundleContext bundleContext;
    private String configLocation = "WEB-INF/keycloak.json";

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public String getConfigLocation() {
        return this.configLocation;
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public KeycloakDeployment resolve(HttpFacade.Request request) {
        if (this.cachedDeployment != null) {
            return this.cachedDeployment;
        }
        this.cachedDeployment = this.findDeployment(request);
        return this.cachedDeployment;
    }

    protected KeycloakDeployment findDeployment(HttpFacade.Request request) {
        if (this.bundleContext == null) {
            throw new IllegalStateException("bundleContext must be set for BundleBasedKeycloakConfigResolver!");
        }
        URL url = this.bundleContext.getBundle().getResource(this.configLocation);
        if (url == null) {
            throw new IllegalStateException("Failed to find the file " + this.configLocation + " on classpath.");
        }
        try {
            InputStream is = url.openStream();
            return KeycloakDeploymentBuilder.build((InputStream)is);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Error reading file' " + this.configLocation + "' from bundle classpath.", ioe);
        }
    }
}

