/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.installed;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.AllowedMethodsHandler;
import io.undertow.server.handlers.GracefulShutdownHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.awt.Desktop;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Deque;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.keycloak.OAuthErrorException;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.ServerRequest;
import org.keycloak.adapters.rotation.AdapterTokenVerifier;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.IDToken;

public class KeycloakInstalled {
    private static final String KEYCLOAK_JSON = "META-INF/keycloak.json";
    private KeycloakDeployment deployment;
    private int listenPort = 0;
    private String listenHostname = "localhost";
    private AccessTokenResponse tokenResponse;
    private String tokenString;
    private String idTokenString;
    private IDToken idToken;
    private AccessToken token;
    private String refreshToken;
    private Status status;
    private Locale locale;
    private ResteasyClient resteasyClient;
    Pattern callbackPattern = Pattern.compile("callback\\s*=\\s*\"([^\"]+)\"");
    Pattern paramPattern = Pattern.compile("param=\"([^\"]+)\"\\s+label=\"([^\"]+)\"\\s+mask=(\\S+)");
    Pattern codePattern = Pattern.compile("code=([^&]+)");
    private CallbackListener callback;
    private DesktopProvider desktopProvider = new DesktopProvider();

    public KeycloakInstalled() {
        InputStream config = Thread.currentThread().getContextClassLoader().getResourceAsStream(KEYCLOAK_JSON);
        this.deployment = KeycloakDeploymentBuilder.build((InputStream)config);
    }

    public KeycloakInstalled(InputStream config) {
        this.deployment = KeycloakDeploymentBuilder.build((InputStream)config);
    }

    public KeycloakInstalled(KeycloakDeployment deployment) {
        this.deployment = deployment;
    }

    public void setResteasyClient(ResteasyClient resteasyClient) {
        this.resteasyClient = resteasyClient;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public void setListenPort(int listenPort) {
        if (listenPort < 0 || listenPort > 65535) {
            throw new IllegalArgumentException("localPort");
        }
        this.listenPort = listenPort;
    }

    public String getListenHostname() {
        return this.listenHostname;
    }

    public void setListenHostname(String listenHostname) {
        this.listenHostname = listenHostname;
    }

    public void login() throws IOException, ServerRequest.HttpFailure, VerificationException, InterruptedException, OAuthErrorException, URISyntaxException {
        if (this.isDesktopSupported()) {
            this.loginDesktop();
        } else {
            this.loginManual();
        }
    }

    public void login(PrintStream printer, Reader reader) throws IOException, ServerRequest.HttpFailure, VerificationException, InterruptedException, OAuthErrorException, URISyntaxException {
        if (this.isDesktopSupported()) {
            this.loginDesktop();
        } else {
            this.loginManual(printer, reader);
        }
    }

    public void logout() throws IOException, InterruptedException, URISyntaxException {
        if (this.status == Status.LOGGED_DESKTOP) {
            this.logoutDesktop();
        }
        this.tokenString = null;
        this.token = null;
        this.idTokenString = null;
        this.idToken = null;
        this.refreshToken = null;
        this.status = null;
    }

    public void loginDesktop() throws IOException, VerificationException, OAuthErrorException, URISyntaxException, ServerRequest.HttpFailure, InterruptedException {
        this.callback = new CallbackListener();
        this.callback.start();
        String redirectUri = this.getRedirectUri(this.callback);
        String state = UUID.randomUUID().toString();
        Pkce pkce = this.deployment.isPkce() ? this.generatePkce() : null;
        String authUrl = this.createAuthUrl(redirectUri, state, pkce);
        this.desktopProvider.browse(new URI(authUrl));
        try {
            this.callback.await();
        }
        catch (InterruptedException e) {
            this.callback.stop();
            throw e;
        }
        if (this.callback.error != null) {
            throw new OAuthErrorException(this.callback.error, this.callback.errorDescription);
        }
        if (!state.equals(this.callback.state)) {
            throw new VerificationException("Invalid state");
        }
        this.processCode(this.callback.code, redirectUri, pkce);
        this.status = Status.LOGGED_DESKTOP;
    }

    public void close() {
        if (this.callback != null) {
            this.callback.stop();
        }
    }

    protected String createAuthUrl(String redirectUri, String state, Pkce pkce) {
        KeycloakUriBuilder builder = this.deployment.getAuthUrl().clone().queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{this.deployment.getResourceName()}).queryParam("redirect_uri", new Object[]{redirectUri}).queryParam("scope", new Object[]{"openid"});
        if (state != null) {
            builder.queryParam("state", new Object[]{state});
        }
        if (this.locale != null) {
            builder.queryParam("ui_locales", new Object[]{this.locale.getLanguage()});
        }
        if (pkce != null) {
            builder.queryParam("code_challenge", new Object[]{pkce.getCodeChallenge()});
            builder.queryParam("code_challenge_method", new Object[]{"S256"});
        }
        return builder.build(new Object[0]).toString();
    }

    protected Pkce generatePkce() {
        return Pkce.generatePkce();
    }

    private void logoutDesktop() throws IOException, URISyntaxException, InterruptedException {
        CallbackListener callback = new CallbackListener();
        callback.start();
        String redirectUri = this.getRedirectUri(callback);
        String logoutUrl = this.deployment.getLogoutUrl().clone().queryParam("post_logout_redirect_uri", new Object[]{redirectUri}).queryParam("id_token_hint", new Object[]{this.idTokenString}).build(new Object[0]).toString();
        this.desktopProvider.browse(new URI(logoutUrl));
        try {
            callback.await();
        }
        catch (InterruptedException e) {
            callback.stop();
            throw e;
        }
    }

    private String getRedirectUri(CallbackListener callback) {
        return String.format("http://%s:%s", this.getListenHostname(), callback.getLocalPort());
    }

    public void loginManual() throws IOException, ServerRequest.HttpFailure, VerificationException {
        this.loginManual(System.out, new InputStreamReader(System.in));
    }

    public void loginManual(PrintStream printer, Reader reader) throws IOException, ServerRequest.HttpFailure, VerificationException {
        String redirectUri = "urn:ietf:wg:oauth:2.0:oob";
        Pkce pkce = this.generatePkce();
        String authUrl = this.createAuthUrl(redirectUri, null, pkce);
        printer.println("Open the following URL in a browser. After login copy/paste the code back and press <enter>");
        printer.println(authUrl);
        printer.println();
        printer.print("Code: ");
        String code = this.readCode(reader);
        this.processCode(code, redirectUri, pkce);
        this.status = Status.LOGGED_MANUAL;
    }

    public String getTokenString() {
        return this.tokenString;
    }

    public String getTokenString(long minValidity, TimeUnit unit) throws VerificationException, IOException, ServerRequest.HttpFailure {
        long expires = (long)this.token.getExpiration() * 1000L - unit.toMillis(minValidity);
        if (expires < System.currentTimeMillis()) {
            this.refreshToken();
        }
        return this.tokenString;
    }

    public void refreshToken() throws IOException, ServerRequest.HttpFailure, VerificationException {
        AccessTokenResponse tokenResponse = ServerRequest.invokeRefresh((KeycloakDeployment)this.deployment, (String)this.refreshToken);
        this.parseAccessToken(tokenResponse);
    }

    public void refreshToken(String refreshToken) throws IOException, ServerRequest.HttpFailure, VerificationException {
        AccessTokenResponse tokenResponse = ServerRequest.invokeRefresh((KeycloakDeployment)this.deployment, (String)refreshToken);
        this.parseAccessToken(tokenResponse);
    }

    private void parseAccessToken(AccessTokenResponse tokenResponse) throws VerificationException {
        this.tokenResponse = tokenResponse;
        this.tokenString = tokenResponse.getToken();
        this.refreshToken = tokenResponse.getRefreshToken();
        this.idTokenString = tokenResponse.getIdToken();
        AdapterTokenVerifier.VerifiedTokens tokens = AdapterTokenVerifier.verifyTokens((String)this.tokenString, (String)this.idTokenString, (KeycloakDeployment)this.deployment);
        this.token = tokens.getAccessToken();
        this.idToken = tokens.getIdToken();
    }

    public AccessToken getToken() {
        return this.token;
    }

    public IDToken getIdToken() {
        return this.idToken;
    }

    public String getIdTokenString() {
        return this.idTokenString;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public AccessTokenResponse getTokenResponse() {
        return this.tokenResponse;
    }

    public void setDesktopProvider(DesktopProvider desktopProvider) {
        this.desktopProvider = desktopProvider;
    }

    public boolean isDesktopSupported() {
        return this.desktopProvider.isDesktopSupported();
    }

    public KeycloakDeployment getDeployment() {
        return this.deployment;
    }

    private void processCode(String code, String redirectUri, Pkce pkce) throws IOException, ServerRequest.HttpFailure, VerificationException {
        AccessTokenResponse tokenResponse = ServerRequest.invokeAccessCodeToToken((KeycloakDeployment)this.deployment, (String)code, (String)redirectUri, null, (String)(pkce == null ? null : pkce.getCodeVerifier()));
        this.parseAccessToken(tokenResponse);
    }

    private String readCode(Reader reader) throws IOException {
        char c;
        StringBuilder sb = new StringBuilder();
        char[] cb = new char[1];
        while (reader.read(cb) != -1 && (c = cb[0]) != ' ' && c != '\n' && c != '\r') {
            sb.append(c);
        }
        return sb.toString();
    }

    public static class DesktopProvider {
        public boolean isDesktopSupported() {
            return Desktop.isDesktopSupported();
        }

        public void browse(URI uri) throws IOException {
            Desktop.getDesktop().browse(uri);
        }
    }

    public static class Pkce {
        public static final int PKCE_CODE_VERIFIER_MAX_LENGTH = 128;
        private final String codeChallenge;
        private final String codeVerifier;

        public Pkce(String codeVerifier, String codeChallenge) {
            this.codeChallenge = codeChallenge;
            this.codeVerifier = codeVerifier;
        }

        public String getCodeChallenge() {
            return this.codeChallenge;
        }

        public String getCodeVerifier() {
            return this.codeVerifier;
        }

        public static Pkce generatePkce() {
            try {
                String codeVerifier = SecretGenerator.getInstance().randomString(128);
                String codeChallenge = Pkce.generateS256CodeChallenge(codeVerifier);
                return new Pkce(codeVerifier, codeChallenge);
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not generate PKCE", ex);
            }
        }

        private static String generateS256CodeChallenge(String codeVerifier) throws Exception {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(codeVerifier.getBytes(StandardCharsets.ISO_8859_1));
            return Base64Url.encode((byte[])md.digest());
        }
    }

    class CallbackListener
    implements HttpHandler {
        private final CountDownLatch shutdownSignal = new CountDownLatch(1);
        private String code;
        private String error;
        private String errorDescription;
        private String state;
        private Undertow server;
        private GracefulShutdownHandler gracefulShutdownHandler;

        CallbackListener() {
        }

        public void start() {
            PathHandler pathHandler = Handlers.path().addExactPath("/", (HttpHandler)this);
            AllowedMethodsHandler allowedMethodsHandler = new AllowedMethodsHandler((HttpHandler)pathHandler, new HttpString[]{Methods.GET});
            this.gracefulShutdownHandler = Handlers.gracefulShutdown((HttpHandler)allowedMethodsHandler);
            this.server = Undertow.builder().setIoThreads(1).setWorkerThreads(1).addHttpListener(KeycloakInstalled.this.getListenPort(), KeycloakInstalled.this.getListenHostname()).setHandler((HttpHandler)this.gracefulShutdownHandler).build();
            this.server.start();
        }

        public void stop() {
            try {
                this.server.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.shutdownSignal.countDown();
        }

        public int getLocalPort() {
            return ((InetSocketAddress)((Undertow.ListenerInfo)this.server.getListenerInfo().get(0)).getAddress()).getPort();
        }

        public void await() throws InterruptedException {
            this.shutdownSignal.await();
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            this.gracefulShutdownHandler.shutdown();
            if (!exchange.getQueryParameters().isEmpty()) {
                this.readQueryParameters(exchange);
            }
            exchange.setStatusCode(302);
            exchange.getResponseHeaders().add(Headers.LOCATION, this.getRedirectUrl());
            exchange.endExchange();
            this.shutdownSignal.countDown();
            ForkJoinPool.commonPool().execute(this::stop);
        }

        private void readQueryParameters(HttpServerExchange exchange) {
            this.code = this.getQueryParameterIfPresent(exchange, "code");
            this.error = this.getQueryParameterIfPresent(exchange, "error");
            this.errorDescription = this.getQueryParameterIfPresent(exchange, "error_description");
            this.state = this.getQueryParameterIfPresent(exchange, "state");
        }

        private String getQueryParameterIfPresent(HttpServerExchange exchange, String name) {
            Map queryParameters = exchange.getQueryParameters();
            return queryParameters.containsKey(name) ? (String)((Deque)queryParameters.get(name)).getFirst() : null;
        }

        private String getRedirectUrl() {
            String redirectUrl = KeycloakInstalled.this.deployment.getTokenUrl().replace("/token", "/delegated");
            if (this.error != null) {
                redirectUrl = redirectUrl + "?error=true";
            }
            return redirectUrl;
        }
    }

    private static enum Status {
        LOGGED_MANUAL,
        LOGGED_DESKTOP;

    }
}

