/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.jetty.core;

import java.security.Principal;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.server.Request;
import org.jboss.logging.Logger;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.AdapterUtils;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.KeycloakAccount;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OAuthRequestAuthenticator;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.RequestAuthenticator;

public class JettyRequestAuthenticator
extends RequestAuthenticator {
    protected static final Logger log = Logger.getLogger(JettyRequestAuthenticator.class);
    protected Request request;
    protected KeycloakPrincipal<RefreshableKeycloakSecurityContext> principal;

    public JettyRequestAuthenticator(HttpFacade facade, KeycloakDeployment deployment, AdapterTokenStore tokenStore, int sslRedirectPort, Request request) {
        super(facade, deployment, tokenStore, sslRedirectPort);
        this.request = request;
    }

    protected OAuthRequestAuthenticator createOAuthAuthenticator() {
        return new OAuthRequestAuthenticator((RequestAuthenticator)this, this.facade, this.deployment, this.sslRedirectPort, this.tokenStore);
    }

    protected void completeOAuthAuthentication(final KeycloakPrincipal<RefreshableKeycloakSecurityContext> skp) {
        this.principal = skp;
        final RefreshableKeycloakSecurityContext securityContext = (RefreshableKeycloakSecurityContext)skp.getKeycloakSecurityContext();
        final Set roles = AdapterUtils.getRolesFromSecurityContext((RefreshableKeycloakSecurityContext)securityContext);
        KeycloakAccount account = new KeycloakAccount(){

            public Principal getPrincipal() {
                return skp;
            }

            public Set<String> getRoles() {
                return roles;
            }

            public KeycloakSecurityContext getKeycloakSecurityContext() {
                return securityContext;
            }
        };
        this.request.setAttribute(KeycloakSecurityContext.class.getName(), (Object)securityContext);
        this.tokenStore.saveAccountInfo(account);
    }

    protected void completeBearerAuthentication(KeycloakPrincipal<RefreshableKeycloakSecurityContext> principal, String method) {
        this.principal = principal;
        RefreshableKeycloakSecurityContext securityContext = (RefreshableKeycloakSecurityContext)principal.getKeycloakSecurityContext();
        Set roles = AdapterUtils.getRolesFromSecurityContext((RefreshableKeycloakSecurityContext)securityContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Completing bearer authentication. Bearer roles: " + roles));
        }
        this.request.setAttribute(KeycloakSecurityContext.class.getName(), (Object)securityContext);
    }

    protected String getHttpSessionId(boolean create) {
        HttpSession session = this.request.getSession(create);
        return session != null ? session.getId() : null;
    }
}

