/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.jetty.core;

import org.eclipse.jetty.server.Request;
import org.jboss.logging.Logger;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.CookieTokenStore;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.KeycloakAccount;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.RequestAuthenticator;

public class JettyCookieTokenStore
implements AdapterTokenStore {
    private static final Logger log = Logger.getLogger(JettyCookieTokenStore.class);
    private Request request;
    private HttpFacade facade;
    private KeycloakDeployment deployment;
    private KeycloakPrincipal<RefreshableKeycloakSecurityContext> authenticatedPrincipal;

    public JettyCookieTokenStore(Request request, HttpFacade facade, KeycloakDeployment deployment) {
        this.request = request;
        this.facade = facade;
        this.deployment = deployment;
    }

    public void checkCurrentToken() {
        this.authenticatedPrincipal = this.checkPrincipalFromCookie();
    }

    public boolean isCached(RequestAuthenticator authenticator) {
        if (this.authenticatedPrincipal != null) {
            log.debug((Object)"remote logged in already. Establish state from cookie");
            RefreshableKeycloakSecurityContext securityContext = (RefreshableKeycloakSecurityContext)this.authenticatedPrincipal.getKeycloakSecurityContext();
            if (!securityContext.getRealm().equals(this.deployment.getRealm())) {
                log.debug((Object)"Account from cookie is from a different realm than for the request.");
                return false;
            }
            securityContext.setCurrentRequestInfo(this.deployment, (AdapterTokenStore)this);
            this.request.setAttribute(KeycloakSecurityContext.class.getName(), (Object)securityContext);
            return true;
        }
        return false;
    }

    public void saveAccountInfo(KeycloakAccount account) {
        RefreshableKeycloakSecurityContext securityContext = (RefreshableKeycloakSecurityContext)account.getKeycloakSecurityContext();
        CookieTokenStore.setTokenCookie((KeycloakDeployment)this.deployment, (HttpFacade)this.facade, (RefreshableKeycloakSecurityContext)securityContext);
    }

    public void logout() {
        CookieTokenStore.removeCookie((HttpFacade)this.facade);
    }

    public void refreshCallback(RefreshableKeycloakSecurityContext secContext) {
        CookieTokenStore.setTokenCookie((KeycloakDeployment)this.deployment, (HttpFacade)this.facade, (RefreshableKeycloakSecurityContext)secContext);
    }

    protected KeycloakPrincipal<RefreshableKeycloakSecurityContext> checkPrincipalFromCookie() {
        KeycloakPrincipal principal = CookieTokenStore.getPrincipalFromCookie((KeycloakDeployment)this.deployment, (HttpFacade)this.facade, (AdapterTokenStore)this);
        if (principal == null) {
            log.debug((Object)"Account was not in cookie or was invalid");
            return null;
        }
        RefreshableKeycloakSecurityContext session = (RefreshableKeycloakSecurityContext)principal.getKeycloakSecurityContext();
        if (session.isActive() && !session.getDeployment().isAlwaysRefreshToken()) {
            return principal;
        }
        boolean success = session.refreshExpiredToken(false);
        if (success && session.isActive()) {
            return principal;
        }
        log.debugf("Cleanup and expire cookie for user %s after failed refresh", (Object)principal.getName());
        CookieTokenStore.removeCookie((HttpFacade)this.facade);
        return null;
    }

    public void saveRequest() {
    }

    public boolean restoreRequest() {
        return false;
    }
}

