/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.jetty;

import java.security.Principal;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.MultiMap;
import org.jboss.logging.Logger;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.AdapterUtils;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.KeycloakAccount;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OAuthRequestAuthenticator;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.RequestAuthenticator;
import org.keycloak.adapters.jetty.AbstractKeycloakJettyAuthenticator;
import org.keycloak.enums.TokenStore;

public abstract class AbstractJettyRequestAuthenticator
extends RequestAuthenticator {
    public static final String __J_METHOD = "org.eclipse.jetty.security.HTTP_METHOD";
    protected static final Logger log = Logger.getLogger(AbstractJettyRequestAuthenticator.class);
    protected AbstractKeycloakJettyAuthenticator valve;
    protected Request request;
    protected KeycloakPrincipal<RefreshableKeycloakSecurityContext> principal;

    public AbstractJettyRequestAuthenticator(HttpFacade facade, KeycloakDeployment deployment, AdapterTokenStore tokenStore, int sslRedirectPort, AbstractKeycloakJettyAuthenticator valve, Request request) {
        super(facade, deployment, tokenStore, sslRedirectPort);
        this.valve = valve;
        this.request = request;
    }

    protected OAuthRequestAuthenticator createOAuthAuthenticator() {
        return new OAuthRequestAuthenticator(this, this.facade, this.deployment, this.sslRedirectPort){

            protected void saveRequest() {
                if (this.deployment.getTokenStore() == TokenStore.SESSION) {
                    AbstractJettyRequestAuthenticator.this.saveServletRequest();
                }
            }
        };
    }

    protected void completeOAuthAuthentication(final KeycloakPrincipal<RefreshableKeycloakSecurityContext> skp) {
        this.principal = skp;
        final RefreshableKeycloakSecurityContext securityContext = (RefreshableKeycloakSecurityContext)skp.getKeycloakSecurityContext();
        final Set roles = AdapterUtils.getRolesFromSecurityContext((RefreshableKeycloakSecurityContext)securityContext);
        KeycloakAccount account = new KeycloakAccount(){

            public Principal getPrincipal() {
                return skp;
            }

            public Set<String> getRoles() {
                return roles;
            }

            public KeycloakSecurityContext getKeycloakSecurityContext() {
                return securityContext;
            }
        };
        this.request.setAttribute(KeycloakSecurityContext.class.getName(), (Object)securityContext);
        this.tokenStore.saveAccountInfo(account);
    }

    protected void completeBearerAuthentication(KeycloakPrincipal<RefreshableKeycloakSecurityContext> principal, String method) {
        this.principal = principal;
        RefreshableKeycloakSecurityContext securityContext = (RefreshableKeycloakSecurityContext)principal.getKeycloakSecurityContext();
        Set roles = AdapterUtils.getRolesFromSecurityContext((RefreshableKeycloakSecurityContext)securityContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Completing bearer authentication. Bearer roles: " + roles));
        }
        this.request.setAttribute(KeycloakSecurityContext.class.getName(), (Object)securityContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreRequest() {
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            return;
        }
        HttpSession httpSession = session;
        synchronized (httpSession) {
            String j_uri = (String)session.getAttribute("org.eclipse.jetty.security.form_URI");
            if (j_uri != null) {
                MultiMap j_post;
                StringBuffer buf = this.request.getRequestURL();
                if (this.request.getQueryString() != null) {
                    buf.append("?").append(this.request.getQueryString());
                }
                if ((j_post = (MultiMap)session.getAttribute("org.eclipse.jetty.security.form_POST")) != null) {
                    this.restoreFormParameters((MultiMap<String>)j_post, this.request);
                }
                session.removeAttribute("org.eclipse.jetty.security.form_URI");
                session.removeAttribute(__J_METHOD);
                session.removeAttribute("org.eclipse.jetty.security.form_POST");
            }
        }
    }

    protected String getHttpSessionId(boolean create) {
        HttpSession session = this.request.getSession(create);
        return session != null ? session.getId() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveServletRequest() {
        HttpSession session;
        HttpSession httpSession = session = this.request.getSession();
        synchronized (httpSession) {
            if (session.getAttribute("org.eclipse.jetty.security.form_URI") == null) {
                StringBuffer buf = this.request.getRequestURL();
                if (this.request.getQueryString() != null) {
                    buf.append("?").append(this.request.getQueryString());
                }
                session.setAttribute("org.eclipse.jetty.security.form_URI", (Object)buf.toString());
                session.setAttribute(__J_METHOD, (Object)this.request.getMethod());
                if ("application/x-www-form-urlencoded".equals(this.request.getContentType()) && "POST".equalsIgnoreCase(this.request.getMethod())) {
                    MultiMap<String> formParameters = this.extractFormParameters(this.request);
                    session.setAttribute("org.eclipse.jetty.security.form_POST", formParameters);
                }
            }
        }
    }

    protected abstract MultiMap<String> extractFormParameters(Request var1);

    protected abstract void restoreFormParameters(MultiMap<String> var1, Request var2);
}

