/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.jetty;

import javax.servlet.http.HttpSession;
import org.eclipse.jetty.server.Request;
import org.jboss.logging.Logger;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.AdapterUtils;
import org.keycloak.adapters.KeycloakAccount;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.RequestAuthenticator;
import org.keycloak.adapters.jetty.AbstractJettyRequestAuthenticator;

public class JettySessionTokenStore
implements AdapterTokenStore {
    private static final Logger log = Logger.getLogger(JettySessionTokenStore.class);
    private Request request;
    private KeycloakDeployment deployment;

    public JettySessionTokenStore(Request request, KeycloakDeployment deployment) {
        this.request = request;
        this.deployment = deployment;
    }

    public void checkCurrentToken() {
        if (this.request.getSession(false) == null) {
            return;
        }
        RefreshableKeycloakSecurityContext session = (RefreshableKeycloakSecurityContext)this.request.getSession().getAttribute(KeycloakSecurityContext.class.getName());
        if (session == null) {
            return;
        }
        if (session.getDeployment() == null) {
            session.setCurrentRequestInfo(this.deployment, (AdapterTokenStore)this);
        }
        if (session.isActive() && !session.getDeployment().isAlwaysRefreshToken()) {
            return;
        }
        boolean success = session.refreshExpiredToken(false);
        if (success && session.isActive()) {
            return;
        }
        this.request.getSession().removeAttribute(KeycloakSecurityContext.class.getName());
        this.request.getSession().invalidate();
    }

    public boolean isCached(RequestAuthenticator authenticator) {
        KeycloakPrincipal principal;
        if (this.request.getSession(false) == null || this.request.getSession().getAttribute(KeycloakSecurityContext.class.getName()) == null) {
            return false;
        }
        log.debug((Object)"remote logged in already. Establish state from session");
        RefreshableKeycloakSecurityContext securityContext = (RefreshableKeycloakSecurityContext)this.request.getSession().getAttribute(KeycloakSecurityContext.class.getName());
        if (!this.deployment.getRealm().equals(securityContext.getRealm())) {
            log.debug((Object)"Account from cookie is from a different realm than for the request.");
            return false;
        }
        securityContext.setCurrentRequestInfo(this.deployment, (AdapterTokenStore)this);
        this.request.setAttribute(KeycloakSecurityContext.class.getName(), (Object)securityContext);
        AbstractJettyRequestAuthenticator jettyAuthenticator = (AbstractJettyRequestAuthenticator)authenticator;
        jettyAuthenticator.principal = principal = AdapterUtils.createPrincipal((KeycloakDeployment)this.deployment, (RefreshableKeycloakSecurityContext)securityContext);
        jettyAuthenticator.restoreRequest();
        return true;
    }

    public void saveAccountInfo(KeycloakAccount account) {
        RefreshableKeycloakSecurityContext securityContext = (RefreshableKeycloakSecurityContext)account.getKeycloakSecurityContext();
        this.request.getSession().setAttribute(KeycloakSecurityContext.class.getName(), (Object)securityContext);
    }

    public void logout() {
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            session.removeAttribute(KeycloakSecurityContext.class.getName());
        }
    }

    public void refreshCallback(RefreshableKeycloakSecurityContext securityContext) {
    }
}

