/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.authentication.ClientCredentialsProviderUtils;
import org.keycloak.common.util.HostUtils;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.common.util.StreamUtil;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.util.JsonSerialization;

public class ServerRequest {
    public static void invokeLogout(KeycloakDeployment deployment, String refreshToken) throws IOException, HttpFailure {
        HttpClient client = deployment.getClient();
        URI uri = deployment.getLogoutUrl().clone().build(new Object[0]);
        ArrayList<NameValuePair> formparams = new ArrayList<NameValuePair>();
        formparams.add((NameValuePair)new BasicNameValuePair("refresh_token", refreshToken));
        HttpPost post = new HttpPost(uri);
        ClientCredentialsProviderUtils.setClientCredentials(deployment, post, formparams);
        UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, "UTF-8");
        post.setEntity((HttpEntity)form);
        HttpResponse response = client.execute((HttpUriRequest)post);
        int status = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        if (status != 204) {
            ServerRequest.error(status, entity);
        }
        if (entity == null) {
            return;
        }
        InputStream is = entity.getContent();
        if (is != null) {
            is.close();
        }
    }

    public static AccessTokenResponse invokeAccessCodeToToken(KeycloakDeployment deployment, String code, String redirectUri, String sessionId) throws IOException, HttpFailure {
        ArrayList<NameValuePair> formparams = new ArrayList<NameValuePair>();
        redirectUri = ServerRequest.stripOauthParametersFromRedirect(redirectUri);
        formparams.add((NameValuePair)new BasicNameValuePair("grant_type", "authorization_code"));
        formparams.add((NameValuePair)new BasicNameValuePair("code", code));
        formparams.add((NameValuePair)new BasicNameValuePair("redirect_uri", redirectUri));
        if (sessionId != null) {
            formparams.add((NameValuePair)new BasicNameValuePair("client_session_state", sessionId));
            formparams.add((NameValuePair)new BasicNameValuePair("client_session_host", HostUtils.getHostName()));
        }
        HttpPost post = new HttpPost(deployment.getTokenUrl());
        ClientCredentialsProviderUtils.setClientCredentials(deployment, post, formparams);
        UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, "UTF-8");
        post.setEntity((HttpEntity)form);
        HttpResponse response = deployment.getClient().execute((HttpUriRequest)post);
        int status = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        if (status != 200) {
            ServerRequest.error(status, entity);
        }
        if (entity == null) {
            throw new HttpFailure(status, null);
        }
        InputStream is = entity.getContent();
        try {
            int c;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while ((c = is.read()) != -1) {
                os.write(c);
            }
            byte[] bytes = os.toByteArray();
            String json = new String(bytes);
            try {
                AccessTokenResponse accessTokenResponse = (AccessTokenResponse)JsonSerialization.readValue((String)json, AccessTokenResponse.class);
                return accessTokenResponse;
            }
            catch (IOException e) {
                throw new IOException(json, e);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static AccessTokenResponse invokeRefresh(KeycloakDeployment deployment, String refreshToken) throws IOException, HttpFailure {
        ArrayList<NameValuePair> formparams = new ArrayList<NameValuePair>();
        formparams.add((NameValuePair)new BasicNameValuePair("grant_type", "refresh_token"));
        formparams.add((NameValuePair)new BasicNameValuePair("refresh_token", refreshToken));
        HttpPost post = new HttpPost(deployment.getTokenUrl());
        ClientCredentialsProviderUtils.setClientCredentials(deployment, post, formparams);
        UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, "UTF-8");
        post.setEntity((HttpEntity)form);
        HttpResponse response = deployment.getClient().execute((HttpUriRequest)post);
        int status = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        if (status != 200) {
            ServerRequest.error(status, entity);
        }
        if (entity == null) {
            throw new HttpFailure(status, null);
        }
        InputStream is = entity.getContent();
        try {
            int c;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while ((c = is.read()) != -1) {
                os.write(c);
            }
            byte[] bytes = os.toByteArray();
            String json = new String(bytes);
            try {
                AccessTokenResponse accessTokenResponse = (AccessTokenResponse)JsonSerialization.readValue((String)json, AccessTokenResponse.class);
                return accessTokenResponse;
            }
            catch (IOException e) {
                throw new IOException(json, e);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void invokeRegisterNode(KeycloakDeployment deployment, String host) throws HttpFailure, IOException {
        String registerNodeUrl = deployment.getRegisterNodeUrl();
        ServerRequest.invokeClientManagementRequest(deployment, host, registerNodeUrl);
    }

    public static void invokeUnregisterNode(KeycloakDeployment deployment, String host) throws HttpFailure, IOException {
        String unregisterNodeUrl = deployment.getUnregisterNodeUrl();
        ServerRequest.invokeClientManagementRequest(deployment, host, unregisterNodeUrl);
    }

    public static void invokeClientManagementRequest(KeycloakDeployment deployment, String host, String endpointUrl) throws HttpFailure, IOException {
        if (endpointUrl == null) {
            throw new IOException("You need to configure URI for register/unregister node for application " + deployment.getResourceName());
        }
        ArrayList<NameValuePair> formparams = new ArrayList<NameValuePair>();
        formparams.add((NameValuePair)new BasicNameValuePair("client_cluster_host", host));
        HttpPost post = new HttpPost(endpointUrl);
        ClientCredentialsProviderUtils.setClientCredentials(deployment, post, formparams);
        UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, "UTF-8");
        post.setEntity((HttpEntity)form);
        HttpResponse response = deployment.getClient().execute((HttpUriRequest)post);
        int status = response.getStatusLine().getStatusCode();
        if (status != 204) {
            HttpEntity entity = response.getEntity();
            ServerRequest.error(status, entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void error(int status, HttpEntity entity) throws HttpFailure, IOException {
        String body = null;
        if (entity != null) {
            InputStream is = entity.getContent();
            try {
                body = StreamUtil.readString((InputStream)is);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        throw new HttpFailure(status, body);
    }

    protected static String stripOauthParametersFromRedirect(String uri) {
        KeycloakUriBuilder builder = KeycloakUriBuilder.fromUri((String)uri).replaceQueryParam("code", null).replaceQueryParam("state", null);
        return builder.build(new Object[0]).toString();
    }

    public static class HttpFailure
    extends Exception {
        private int status;
        private String error;

        public HttpFailure(int status, String error) {
            this.status = status;
            this.error = error;
        }

        public int getStatus() {
            return this.status;
        }

        public String getError() {
            return this.error;
        }
    }
}

