/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.util;

import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKParser;

public class JWKSUtils {
    public static Map<String, PublicKey> getKeysForUse(JSONWebKeySet keySet, JWK.Use requestedUse) {
        HashMap<String, PublicKey> result = new HashMap<String, PublicKey>();
        for (JWK jwk : keySet.getKeys()) {
            JWKParser parser = JWKParser.create(jwk);
            if (!jwk.getPublicKeyUse().equals(requestedUse.asString()) || !parser.isKeyTypeSupported(jwk.getKeyType())) continue;
            result.put(jwk.getKeyId(), parser.toPublicKey());
        }
        return result;
    }

    public static JWK getKeyForUse(JSONWebKeySet keySet, JWK.Use requestedUse) {
        for (JWK jwk : keySet.getKeys()) {
            JWKParser parser = JWKParser.create(jwk);
            if (!parser.getJwk().getPublicKeyUse().equals(requestedUse.asString()) || !parser.isKeyTypeSupported(jwk.getKeyType())) continue;
            return jwk;
        }
        return null;
    }
}

