/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.jetty;

import javax.servlet.ServletRequest;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.jetty.JettySessionTokenStore;
import org.keycloak.adapters.jetty.core.AbstractKeycloakJettyAuthenticator;

public class KeycloakJettyAuthenticator
extends AbstractKeycloakJettyAuthenticator {
    public AdapterTokenStore createSessionTokenStore(Request request, KeycloakDeployment resolvedDeployment) {
        return new JettySessionTokenStore(request, resolvedDeployment);
    }

    protected Request resolveRequest(ServletRequest req) {
        return req instanceof Request ? (Request)req : AbstractHttpConnection.getCurrentConnection().getRequest();
    }

    protected Authentication createAuthentication(UserIdentity userIdentity) {
        return new AbstractKeycloakJettyAuthenticator.KeycloakAuthentication(this.getAuthMethod(), userIdentity){

            public void logout() {
                KeycloakJettyAuthenticator.this.logoutCurrent(AbstractHttpConnection.getCurrentConnection().getRequest());
            }
        };
    }
}

