/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.jetty;

import javax.servlet.http.HttpSession;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.MultiMap;
import org.keycloak.adapters.spi.AdapterSessionStore;
import org.keycloak.common.util.MultivaluedHashMap;

public class JettyAdapterSessionStore
implements AdapterSessionStore {
    public static final String CACHED_FORM_PARAMETERS = "__CACHED_FORM_PARAMETERS";
    protected Request myRequest;

    public JettyAdapterSessionStore(Request request) {
        this.myRequest = request;
    }

    protected MultiMap<String> extractFormParameters(Request base_request) {
        base_request.extractParameters();
        return base_request.getParameters();
    }

    protected void restoreFormParameters(MultiMap<String> j_post, Request base_request) {
        base_request.setParameters(j_post);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restoreRequest() {
        HttpSession session = this.myRequest.getSession(false);
        if (session == null) {
            return false;
        }
        HttpSession httpSession = session;
        synchronized (httpSession) {
            String j_uri = (String)session.getAttribute("org.eclipse.jetty.security.form_URI");
            if (j_uri != null) {
                StringBuffer buf = this.myRequest.getRequestURL();
                if (this.myRequest.getQueryString() != null) {
                    buf.append("?").append(this.myRequest.getQueryString());
                }
                if (j_uri.equals(buf.toString())) {
                    String method = (String)session.getAttribute("org.eclipse.jetty.security.HTTP_METHOD");
                    this.myRequest.setMethod(HttpMethod.valueOf((String)method.toUpperCase()), method);
                    MultivaluedHashMap j_post = (MultivaluedHashMap)session.getAttribute(CACHED_FORM_PARAMETERS);
                    if (j_post != null) {
                        this.myRequest.setContentType("application/x-www-form-urlencoded");
                        MultiMap map = new MultiMap();
                        for (String key : j_post.keySet()) {
                            for (String val : j_post.getList((Object)key)) {
                                map.add(key, (Object)val);
                            }
                        }
                        this.restoreFormParameters((MultiMap<String>)map, this.myRequest);
                    }
                    session.removeAttribute("org.eclipse.jetty.security.form_URI");
                    session.removeAttribute("org.eclipse.jetty.security.HTTP_METHOD");
                    session.removeAttribute("org.eclipse.jetty.security.form_POST");
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRequest() {
        HttpSession session;
        HttpSession httpSession = session = this.myRequest.getSession();
        synchronized (httpSession) {
            if (session.getAttribute("org.eclipse.jetty.security.form_URI") == null) {
                StringBuffer buf = this.myRequest.getRequestURL();
                if (this.myRequest.getQueryString() != null) {
                    buf.append("?").append(this.myRequest.getQueryString());
                }
                session.setAttribute("org.eclipse.jetty.security.form_URI", (Object)buf.toString());
                session.setAttribute("org.eclipse.jetty.security.HTTP_METHOD", (Object)this.myRequest.getMethod());
                if ("application/x-www-form-urlencoded".equals(this.myRequest.getContentType()) && "POST".equalsIgnoreCase(this.myRequest.getMethod())) {
                    MultiMap<String> formParameters = this.extractFormParameters(this.myRequest);
                    MultivaluedHashMap map = new MultivaluedHashMap();
                    for (String key : formParameters.keySet()) {
                        for (Object value : formParameters.getValues(key)) {
                            map.add((Object)key, (Object)((String)value));
                        }
                    }
                    session.setAttribute(CACHED_FORM_PARAMETERS, (Object)map);
                }
            }
        }
    }
}

