/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.keycloak.common.util.Base64;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.BouncyIntegration;
import org.keycloak.common.util.DerUtils;
import org.keycloak.common.util.PemException;

public final class PemUtils {
    private PemUtils() {
    }

    public static X509Certificate decodeCertificate(String cert) {
        if (cert == null) {
            return null;
        }
        try {
            byte[] der = PemUtils.pemToDer(cert);
            ByteArrayInputStream bis = new ByteArrayInputStream(der);
            return DerUtils.decodeCertificate(bis);
        }
        catch (Exception e) {
            throw new PemException(e);
        }
    }

    public static PublicKey decodePublicKey(String pem) {
        if (pem == null) {
            return null;
        }
        try {
            byte[] der = PemUtils.pemToDer(pem);
            return DerUtils.decodePublicKey(der);
        }
        catch (Exception e) {
            throw new PemException(e);
        }
    }

    public static PrivateKey decodePrivateKey(String pem) {
        if (pem == null) {
            return null;
        }
        try {
            byte[] der = PemUtils.pemToDer(pem);
            return DerUtils.decodePrivateKey(der);
        }
        catch (Exception e) {
            throw new PemException(e);
        }
    }

    public static String encodeKey(Key key) {
        return PemUtils.encode(key);
    }

    public static String encodeCertificate(Certificate certificate) {
        return PemUtils.encode(certificate);
    }

    private static String encode(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter();
            JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)writer);
            pemWriter.writeObject(obj);
            pemWriter.flush();
            pemWriter.close();
            String s = writer.toString();
            return PemUtils.removeBeginEnd(s);
        }
        catch (Exception e) {
            throw new PemException(e);
        }
    }

    public static byte[] pemToDer(String pem) {
        try {
            pem = PemUtils.removeBeginEnd(pem);
            return Base64.decode(pem);
        }
        catch (IOException ioe) {
            throw new PemException(ioe);
        }
    }

    public static String removeBeginEnd(String pem) {
        pem = pem.replaceAll("-----BEGIN (.*)-----", "");
        pem = pem.replaceAll("-----END (.*)----", "");
        pem = pem.replaceAll("\r\n", "");
        pem = pem.replaceAll("\n", "");
        return pem.trim();
    }

    public static String generateThumbprint(String[] certChain, String encoding) throws NoSuchAlgorithmException {
        return Base64Url.encode(PemUtils.generateThumbprintBytes(certChain, encoding));
    }

    static byte[] generateThumbprintBytes(String[] certChain, String encoding) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(encoding).digest(PemUtils.pemToDer(certChain[0]));
    }

    static {
        BouncyIntegration.init();
    }
}

