/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.authentication;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.jboss.logging.Logger;
import org.keycloak.adapters.AdapterUtils;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.authentication.ClientCredentialsProvider;
import org.keycloak.common.util.Time;
import org.keycloak.crypto.JavaAlgorithm;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.representations.JsonWebToken;

public class JWTClientSecretCredentialsProvider
implements ClientCredentialsProvider {
    private static final Logger logger = Logger.getLogger(JWTClientSecretCredentialsProvider.class);
    public static final String PROVIDER_ID = "secret-jwt";
    private SecretKey clientSecret;
    private String clientSecretJwtAlg = "HS256";

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public void init(KeycloakDeployment deployment, Object config) {
        if (!(config instanceof Map)) {
            throw new RuntimeException("Configuration of jwt credentials by client secret is missing or incorrect for client '" + deployment.getResourceName() + "'. Check your adapter configuration");
        }
        Map cfg = (Map)config;
        String clientSecretString = (String)cfg.get("secret");
        if (clientSecretString == null) {
            throw new RuntimeException("Missing parameter secret-jwt in configuration of jwt for client " + deployment.getResourceName());
        }
        String clientSecretJwtAlg = (String)cfg.get("algorithm");
        if (clientSecretJwtAlg == null) {
            this.setClientSecret(clientSecretString);
        } else if (this.isValidClientSecretJwtAlg(clientSecretJwtAlg)) {
            this.setClientSecret(clientSecretString, clientSecretJwtAlg);
        } else {
            throw new RuntimeException("Invalid parameter secret-jwt in configuration of jwt for client " + deployment.getResourceName());
        }
    }

    private boolean isValidClientSecretJwtAlg(String clientSecretJwtAlg) {
        boolean ret = false;
        if ("HS256".equals(clientSecretJwtAlg) || "HS384".equals(clientSecretJwtAlg) || "HS512".equals(clientSecretJwtAlg)) {
            ret = true;
        }
        return ret;
    }

    @Override
    public void setClientCredentials(KeycloakDeployment deployment, Map<String, String> requestHeaders, Map<String, String> formParams) {
        String signedToken = this.createSignedRequestToken(deployment.getResourceName(), deployment.getRealmInfoUrl());
        formParams.put("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
        formParams.put("client_assertion", signedToken);
    }

    public void setClientSecret(String clientSecretString) {
        this.setClientSecret(clientSecretString, "HS256");
    }

    public void setClientSecret(String clientSecretString, String algorithm) {
        this.clientSecret = new SecretKeySpec(clientSecretString.getBytes(StandardCharsets.UTF_8), JavaAlgorithm.getJavaAlgorithm((String)algorithm));
        this.clientSecretJwtAlg = algorithm;
    }

    public String createSignedRequestToken(String clientId, String realmInfoUrl) {
        return this.createSignedRequestToken(clientId, realmInfoUrl, this.clientSecretJwtAlg);
    }

    public String createSignedRequestToken(String clientId, String realmInfoUrl, String algorithm) {
        JsonWebToken jwt = this.createRequestToken(clientId, realmInfoUrl);
        String signedRequestToken = null;
        signedRequestToken = "HS512".equals(algorithm) ? new JWSBuilder().jsonContent((Object)jwt).hmac512(this.clientSecret) : ("HS384".equals(algorithm) ? new JWSBuilder().jsonContent((Object)jwt).hmac384(this.clientSecret) : new JWSBuilder().jsonContent((Object)jwt).hmac256(this.clientSecret));
        return signedRequestToken;
    }

    protected JsonWebToken createRequestToken(String clientId, String realmInfoUrl) {
        JsonWebToken reqToken = new JsonWebToken();
        reqToken.id(AdapterUtils.generateId());
        reqToken.issuer(clientId);
        reqToken.subject(clientId);
        reqToken.audience(new String[]{realmInfoUrl});
        int now = Time.currentTime();
        reqToken.issuedAt(now);
        reqToken.expiration(now + 10);
        reqToken.notBefore(now);
        return reqToken;
    }
}

