/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters;

import org.jboss.logging.Logger;
import org.keycloak.adapters.BearerTokenRequestAuthenticator;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OIDCAuthenticationError;
import org.keycloak.adapters.spi.AuthOutcome;
import org.keycloak.adapters.spi.HttpFacade;

public class QueryParameterTokenRequestAuthenticator
extends BearerTokenRequestAuthenticator {
    public static final String ACCESS_TOKEN = "access_token";
    protected Logger log = Logger.getLogger(QueryParameterTokenRequestAuthenticator.class);

    public QueryParameterTokenRequestAuthenticator(KeycloakDeployment deployment) {
        super(deployment);
    }

    @Override
    public AuthOutcome authenticate(HttpFacade exchange) {
        if (!this.deployment.isOAuthQueryParameterEnabled()) {
            return AuthOutcome.NOT_ATTEMPTED;
        }
        this.tokenString = null;
        this.tokenString = this.getAccessTokenFromQueryParameter(exchange);
        if (this.tokenString == null || this.tokenString.trim().isEmpty()) {
            this.log.debug((Object)"Token is not present in query");
            this.challenge = this.challengeResponse(exchange, OIDCAuthenticationError.Reason.NO_QUERY_PARAMETER_ACCESS_TOKEN, null, null);
            return AuthOutcome.NOT_ATTEMPTED;
        }
        return this.authenticateToken(exchange, this.tokenString);
    }

    String getAccessTokenFromQueryParameter(HttpFacade exchange) {
        try {
            if (exchange != null && exchange.getRequest() != null) {
                return exchange.getRequest().getQueryParamValue(ACCESS_TOKEN);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

