/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.info;

import java.util.List;
import java.util.stream.Collectors;
import org.keycloak.common.crypto.CryptoIntegration;
import org.keycloak.common.crypto.CryptoProvider;

public class CryptoInfoRepresentation {
    private String cryptoProvider;
    private List<String> supportedKeystoreTypes;

    public static CryptoInfoRepresentation create() {
        CryptoInfoRepresentation info = new CryptoInfoRepresentation();
        CryptoProvider cryptoProvider = CryptoIntegration.getProvider();
        info.cryptoProvider = cryptoProvider.getClass().getSimpleName();
        info.supportedKeystoreTypes = CryptoIntegration.getProvider().getSupportedKeyStoreTypes().map(Enum::toString).collect(Collectors.toList());
        return info;
    }

    public String getCryptoProvider() {
        return this.cryptoProvider;
    }

    public void setCryptoProvider(String cryptoProvider) {
        this.cryptoProvider = cryptoProvider;
    }

    public List<String> getSupportedKeystoreTypes() {
        return this.supportedKeystoreTypes;
    }

    public void setSupportedKeystoreTypes(List<String> supportedKeystoreTypes) {
        this.supportedKeystoreTypes = supportedKeystoreTypes;
    }
}

