/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import org.jboss.logging.Logger;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;

public class SystemClientUtil {
    public static final String SYSTEM_CLIENT_ID = "_system";
    private static final Logger logger = Logger.getLogger(SystemClientUtil.class);

    public static ClientModel getSystemClient(RealmModel realm) {
        ClientModel client = realm.getClientByClientId("account");
        if (client != null) {
            return client;
        }
        client = realm.getClientByClientId(SYSTEM_CLIENT_ID);
        if (client != null) {
            return client;
        }
        logger.warnf("Client '%s' not available. Creating system client '%s' for system operations", (Object)"account", (Object)SYSTEM_CLIENT_ID);
        client = realm.addClient(SYSTEM_CLIENT_ID);
        client.setName(SYSTEM_CLIENT_ID);
        return client;
    }
}

