/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.keycloak.common.util.CollectionUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.UserModel;
import org.keycloak.storage.ReadOnlyException;
import org.keycloak.userprofile.AttributeChangeListener;
import org.keycloak.userprofile.Attributes;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileMetadata;
import org.keycloak.userprofile.ValidationException;
import org.keycloak.utils.StringUtil;

public final class DefaultUserProfile
implements UserProfile {
    protected final UserProfileMetadata metadata;
    private final Function<Attributes, UserModel> userSupplier;
    private final Attributes attributes;
    private final KeycloakSession session;
    private boolean validated;
    private UserModel user;

    public DefaultUserProfile(UserProfileMetadata metadata, Attributes attributes, Function<Attributes, UserModel> userCreator, UserModel user, KeycloakSession session) {
        this.metadata = metadata;
        this.userSupplier = userCreator;
        this.attributes = attributes;
        this.user = user;
        this.session = session;
    }

    @Override
    public void validate() {
        ValidationException validationException = new ValidationException();
        for (String attributeName : this.attributes.nameSet()) {
            this.attributes.validate(attributeName, validationException);
        }
        if (validationException.hasError(new String[0])) {
            throw validationException;
        }
        this.validated = true;
    }

    @Override
    public UserModel create() throws ValidationException {
        if (this.user != null) {
            throw new RuntimeException("User already created");
        }
        if (!this.validated) {
            this.validate();
        }
        this.user = this.userSupplier.apply(this.attributes);
        return this.updateInternal(this.user, false, new AttributeChangeListener[0]);
    }

    @Override
    public void update(boolean removeAttributes, AttributeChangeListener ... changeListener) {
        if (!this.validated) {
            this.validate();
        }
        this.updateInternal(this.user, removeAttributes, changeListener);
    }

    private UserModel updateInternal(UserModel user, boolean removeAttributes, AttributeChangeListener ... changeListener) {
        if (user == null) {
            throw new RuntimeException("No user model provided for persisting changes");
        }
        try {
            List<String> currentValue;
            for (Map.Entry<String, List<String>> attribute : this.attributes.getWritable().entrySet()) {
                boolean ignoreEmptyValue;
                List updatedValue;
                String name = attribute.getKey();
                currentValue = user.getAttributeStream(name).filter(Objects::nonNull).collect(Collectors.toList());
                if (CollectionUtil.collectionEquals(currentValue, updatedValue = attribute.getValue().stream().filter(StringUtil::isNotBlank).collect(Collectors.toList()))) continue;
                boolean bl = ignoreEmptyValue = !removeAttributes && updatedValue.isEmpty();
                if (this.isCustomAttribute(name) && ignoreEmptyValue) continue;
                user.setAttribute(name, updatedValue);
                if ("email".equals(name) && this.metadata.getContext().isResetEmailVerified()) {
                    user.setEmailVerified(false);
                }
                for (AttributeChangeListener listener : changeListener) {
                    listener.onChange(name, user, currentValue);
                }
            }
            if (removeAttributes) {
                HashSet attrsToRemove = new HashSet(user.getAttributes().keySet());
                attrsToRemove.removeAll(this.attributes.nameSet());
                for (String attr : attrsToRemove) {
                    if (this.attributes.isReadOnly(attr)) continue;
                    currentValue = user.getAttributeStream(attr).filter(Objects::nonNull).collect(Collectors.toList());
                    user.removeAttribute(attr);
                    for (AttributeChangeListener listener : changeListener) {
                        listener.onChange(attr, user, currentValue);
                    }
                }
            }
        }
        catch (ModelException | ReadOnlyException e) {
            throw e;
        }
        catch (Exception cause) {
            throw new RuntimeException("Unexpected error when persisting user profile", cause);
        }
        return user;
    }

    private boolean isCustomAttribute(String name) {
        return !this.getAttributes().isRootAttribute(name);
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }
}

