/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.profile.ProfileConfigResolver;
import org.keycloak.common.profile.ProfileException;
import org.keycloak.common.profile.PropertiesFileProfileConfigResolver;
import org.keycloak.common.profile.PropertiesProfileConfigResolver;
import org.keycloak.common.util.KerberosJdkProvider;

public class Profile {
    private static final Logger logger = Logger.getLogger(Profile.class);
    private static final List<ProfileConfigResolver> DEFAULT_RESOLVERS = new LinkedList<ProfileConfigResolver>();
    private static Profile CURRENT;
    private final ProfileName profileName;
    private final Map<Feature, Boolean> features;

    public static Profile defaults() {
        return Profile.configure(new ProfileConfigResolver[0]);
    }

    public static Profile configure(ProfileConfigResolver ... resolvers) {
        ProfileName profile = Arrays.stream(resolvers).map(ProfileConfigResolver::getProfileName).filter(Objects::nonNull).findFirst().orElse(ProfileName.DEFAULT);
        Map<Feature, Boolean> features = Arrays.stream(Feature.values()).collect(Collectors.toMap(f -> f, f -> Profile.isFeatureEnabled(profile, f, resolvers)));
        Profile.verifyConfig(features);
        CURRENT = new Profile(profile, features);
        return CURRENT;
    }

    public static Profile init(ProfileName profileName, Map<Feature, Boolean> features) {
        CURRENT = new Profile(profileName, features);
        return CURRENT;
    }

    private Profile(ProfileName profileName, Map<Feature, Boolean> features) {
        this.profileName = profileName;
        this.features = Collections.unmodifiableMap(features);
        this.logUnsupportedFeatures();
    }

    public static Profile getInstance() {
        return CURRENT;
    }

    public static boolean isFeatureEnabled(Feature feature) {
        return Profile.getInstance().features.get((Object)feature);
    }

    public ProfileName getName() {
        return this.profileName;
    }

    public Set<Feature> getAllFeatures() {
        return this.features.keySet();
    }

    public Set<Feature> getDisabledFeatures() {
        return this.features.entrySet().stream().filter(e -> (Boolean)e.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Set<Feature> getPreviewFeatures() {
        return Stream.concat(this.getFeatures(Feature.Type.PREVIEW).stream(), this.getFeatures(Feature.Type.PREVIEW_DISABLED_BY_DEFAULT).stream()).collect(Collectors.toSet());
    }

    public Set<Feature> getExperimentalFeatures() {
        return this.getFeatures(Feature.Type.EXPERIMENTAL);
    }

    public Set<Feature> getDeprecatedFeatures() {
        return this.getFeatures(Feature.Type.DEPRECATED);
    }

    public Set<Feature> getFeatures(Feature.Type type) {
        return this.features.keySet().stream().filter(f -> f.getType().equals((Object)type)).collect(Collectors.toSet());
    }

    public Map<Feature, Boolean> getFeatures() {
        return this.features;
    }

    private static Boolean isFeatureEnabled(ProfileName profile, Feature feature, ProfileConfigResolver ... resolvers) {
        ProfileConfigResolver.FeatureConfig configuration = Arrays.stream(resolvers).map(r -> r.getFeatureConfig(feature)).filter(r -> !r.equals((Object)ProfileConfigResolver.FeatureConfig.UNCONFIGURED)).findFirst().orElse(ProfileConfigResolver.FeatureConfig.UNCONFIGURED);
        switch (configuration) {
            case ENABLED: {
                return true;
            }
            case DISABLED: {
                return false;
            }
        }
        switch (feature.getType()) {
            case DEFAULT: {
                return true;
            }
            case PREVIEW: {
                return profile.equals((Object)ProfileName.PREVIEW);
            }
        }
        return false;
    }

    private static void verifyConfig(Map<Feature, Boolean> features) {
        for (Feature f : features.keySet()) {
            if (!features.get((Object)f).booleanValue() || f.getDependencies() == null) continue;
            for (Feature d : f.getDependencies()) {
                if (features.get((Object)d).booleanValue()) continue;
                throw new ProfileException("Feature " + f.getKey() + " depends on disabled feature " + d.getKey());
            }
        }
    }

    private void logUnsupportedFeatures() {
        this.logUnsupportedFeatures(Feature.Type.PREVIEW, this.getPreviewFeatures(), Logger.Level.INFO);
        this.logUnsupportedFeatures(Feature.Type.EXPERIMENTAL, this.getExperimentalFeatures(), Logger.Level.WARN);
        this.logUnsupportedFeatures(Feature.Type.DEPRECATED, this.getDeprecatedFeatures(), Logger.Level.WARN);
    }

    private void logUnsupportedFeatures(Feature.Type type, Set<Feature> checkedFeatures, Logger.Level level) {
        Set checkedFeatureTypes = checkedFeatures.stream().map(Feature::getType).collect(Collectors.toSet());
        String enabledFeaturesOfType = this.features.entrySet().stream().filter(e -> (Boolean)e.getValue() != false && checkedFeatureTypes.contains((Object)((Feature)((Object)((Object)e.getKey()))).getType())).map(e -> ((Feature)((Object)((Object)e.getKey()))).getKey()).sorted().collect(Collectors.joining(", "));
        if (!enabledFeaturesOfType.isEmpty()) {
            logger.logv(level, "{0} features enabled: {1}", (Object)type.getLabel(), (Object)enabledFeaturesOfType);
        }
    }

    static {
        DEFAULT_RESOLVERS.add(new PropertiesProfileConfigResolver(System.getProperties()));
        DEFAULT_RESOLVERS.add(new PropertiesFileProfileConfigResolver());
    }

    public static enum ProfileName {
        DEFAULT,
        PREVIEW;

    }

    public static enum Feature {
        AUTHORIZATION("Authorization Service", Type.DEFAULT),
        ACCOUNT_API("Account Management REST API", Type.DEFAULT),
        ACCOUNT2("Account Management Console version 2", Type.DEFAULT, ACCOUNT_API),
        ACCOUNT3("Account Management Console version 3", Type.PREVIEW, ACCOUNT_API),
        ADMIN_FINE_GRAINED_AUTHZ("Fine-Grained Admin Permissions", Type.PREVIEW),
        ADMIN_API("Admin API", Type.DEFAULT),
        ADMIN2("New Admin Console", Type.DEFAULT, ADMIN_API),
        DOCKER("Docker Registry protocol", Type.DISABLED_BY_DEFAULT),
        IMPERSONATION("Ability for admins to impersonate users", Type.DEFAULT),
        SCRIPTS("Write custom authenticators using JavaScript", Type.PREVIEW),
        TOKEN_EXCHANGE("Token Exchange Service", Type.PREVIEW),
        WEB_AUTHN("W3C Web Authentication (WebAuthn)", Type.DEFAULT),
        CLIENT_POLICIES("Client configuration policies", Type.DEFAULT),
        CIBA("OpenID Connect Client Initiated Backchannel Authentication (CIBA)", Type.DEFAULT),
        MAP_STORAGE("New store", Type.EXPERIMENTAL),
        PAR("OAuth 2.0 Pushed Authorization Requests (PAR)", Type.DEFAULT),
        DECLARATIVE_USER_PROFILE("Configure user profiles using a declarative style", Type.PREVIEW),
        DYNAMIC_SCOPES("Dynamic OAuth 2.0 scopes", Type.EXPERIMENTAL),
        CLIENT_SECRET_ROTATION("Client Secret Rotation", Type.PREVIEW),
        STEP_UP_AUTHENTICATION("Step-up Authentication", Type.DEFAULT),
        KERBEROS("Kerberos", KerberosJdkProvider.getProvider().isKerberosAvailable() ? Type.DEFAULT : Type.DISABLED_BY_DEFAULT),
        RECOVERY_CODES("Recovery codes", Type.PREVIEW),
        UPDATE_EMAIL("Update Email Action", Type.PREVIEW),
        JS_ADAPTER("Host keycloak.js and keycloak-authz.js through the Keycloak server", Type.DEFAULT),
        FIPS("FIPS 140-2 mode", Type.DISABLED_BY_DEFAULT),
        DPOP("OAuth 2.0 Demonstrating Proof-of-Possession at the Application Layer", Type.PREVIEW),
        LINKEDIN_OAUTH("LinkedIn Social Identity Provider based on OAuth", Type.DEPRECATED),
        DEVICE_FLOW("OAuth 2.0 Device Authorization Grant", Type.DEFAULT),
        TRANSIENT_USERS("Transient users for brokering", Type.EXPERIMENTAL),
        MULTI_SITE("Multi-site support", Type.PREVIEW);

        private final Type type;
        private final String label;
        private Set<Feature> dependencies;

        private Feature(String label, Type type) {
            this.label = label;
            this.type = type;
        }

        private Feature(String label, Type type, Feature ... dependencies) {
            this.label = label;
            this.type = type;
            this.dependencies = Arrays.stream(dependencies).collect(Collectors.toSet());
        }

        public String getKey() {
            return this.name().toLowerCase().replaceAll("_", "-");
        }

        public String getLabel() {
            return this.label;
        }

        public Type getType() {
            return this.type;
        }

        public Set<Feature> getDependencies() {
            return this.dependencies;
        }

        public static enum Type {
            DEFAULT("Default"),
            DISABLED_BY_DEFAULT("Disabled by default"),
            PREVIEW("Preview"),
            PREVIEW_DISABLED_BY_DEFAULT("Preview disabled by default"),
            EXPERIMENTAL("Experimental"),
            DEPRECATED("Deprecated");

            private final String label;

            private Type(String label) {
                this.label = label;
            }

            public String getLabel() {
                return this.label;
            }
        }
    }
}

