/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.common.Version;

public class Profile {
    private static final Logger logger = Logger.getLogger(Profile.class);
    private static Profile CURRENT = new Profile();
    private final ProductValue product;
    private final ProfileValue profile;
    private final Set<Feature> disabledFeatures = new HashSet<Feature>();
    private final Set<Feature> previewFeatures = new HashSet<Feature>();
    private final Set<Feature> experimentalFeatures = new HashSet<Feature>();

    private Profile() {
        Config config = new Config();
        this.product = "rh-sso".equals(Version.NAME) ? ProductValue.RHSSO : ProductValue.KEYCLOAK;
        this.profile = ProfileValue.valueOf(config.getProfile().toUpperCase());
        block6: for (Feature f : Feature.values()) {
            Boolean enabled = config.getConfig(f);
            switch (f.getType()) {
                case DEFAULT: {
                    if (enabled == null || enabled.booleanValue()) continue block6;
                    this.disabledFeatures.add(f);
                    continue block6;
                }
                case DISABLED_BY_DEFAULT: {
                    if (enabled != null && enabled.booleanValue()) continue block6;
                    this.disabledFeatures.add(f);
                    continue block6;
                }
                case PREVIEW: {
                    this.previewFeatures.add(f);
                    if (enabled == null || !enabled.booleanValue()) {
                        this.disabledFeatures.add(f);
                        continue block6;
                    }
                    logger.info((Object)("Preview feature enabled: " + f.name().toLowerCase()));
                    continue block6;
                }
                case EXPERIMENTAL: {
                    this.experimentalFeatures.add(f);
                    if (enabled == null || !enabled.booleanValue()) {
                        this.disabledFeatures.add(f);
                        continue block6;
                    }
                    logger.warn((Object)("Experimental feature enabled: " + f.name().toLowerCase()));
                }
            }
        }
    }

    public static void init() {
        CURRENT = new Profile();
    }

    public static String getName() {
        return Profile.CURRENT.profile.name().toLowerCase();
    }

    public static Set<Feature> getDisabledFeatures() {
        return Profile.CURRENT.disabledFeatures;
    }

    public static Set<Feature> getPreviewFeatures() {
        return Profile.CURRENT.previewFeatures;
    }

    public static Set<Feature> getExperimentalFeatures() {
        return Profile.CURRENT.experimentalFeatures;
    }

    public static boolean isFeatureEnabled(Feature feature) {
        return !Profile.CURRENT.disabledFeatures.contains((Object)feature);
    }

    private class Config {
        private Properties properties = new Properties();

        public Config() {
            try {
                File file;
                String jbossServerConfigDir = System.getProperty("jboss.server.config.dir");
                if (jbossServerConfigDir != null && (file = new File(jbossServerConfigDir, "profile.properties")).isFile()) {
                    this.properties.load(new FileInputStream(file));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String getProfile() {
            String profile = System.getProperty("keycloak.profile");
            if (profile != null) {
                return profile;
            }
            profile = this.properties.getProperty("profile");
            if (profile != null) {
                return profile;
            }
            return Version.DEFAULT_PROFILE;
        }

        public Boolean getConfig(Feature feature) {
            String config = System.getProperty("keycloak.profile.feature." + feature.name().toLowerCase());
            if (config == null) {
                config = this.properties.getProperty("feature." + feature.name().toLowerCase());
            }
            if (config == null) {
                return null;
            }
            if (config.equals("enabled")) {
                return Boolean.TRUE;
            }
            if (config.equals("disabled")) {
                return Boolean.FALSE;
            }
            throw new RuntimeException("Invalid value for feature " + config);
        }
    }

    private static enum ProfileValue {
        COMMUNITY,
        PRODUCT,
        PREVIEW;

    }

    private static enum ProductValue {
        KEYCLOAK,
        RHSSO;

    }

    public static enum Feature {
        ACCOUNT2(Type.EXPERIMENTAL),
        ACCOUNT_API(Type.PREVIEW),
        ADMIN_FINE_GRAINED_AUTHZ(Type.PREVIEW),
        DOCKER(Type.DISABLED_BY_DEFAULT),
        IMPERSONATION(Type.DEFAULT),
        OPENSHIFT_INTEGRATION(Type.DEFAULT),
        SCRIPTS(Type.PREVIEW),
        TOKEN_EXCHANGE(Type.PREVIEW),
        AUTHZ_DROOLS_POLICY(Type.PREVIEW);

        private Type type;

        private Feature(Type type) {
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }
    }

    public static enum Type {
        DEFAULT,
        DISABLED_BY_DEFAULT,
        PREVIEW,
        EXPERIMENTAL;

    }
}

