/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.it.utils;

import java.io.File;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.jboss.logging.Logger;
import org.keycloak.common.Version;
import org.keycloak.it.junit5.extension.CLIResult;
import org.keycloak.it.utils.KeycloakDistribution;
import org.keycloak.it.utils.Maven;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.ToStringConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.RemoteDockerImage;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.ResourceReaper;

public final class DockerKeycloakDistribution
implements KeycloakDistribution {
    private static final Logger LOGGER = Logger.getLogger(DockerKeycloakDistribution.class);
    private boolean debug;
    private boolean manualStop;
    private int exitCode = -1;
    private String stdout = "";
    private String stderr = "";
    private ToStringConsumer backupConsumer = new ToStringConsumer();
    private File dockerScriptFile = new File("../../container/ubi-null.sh");
    private GenericContainer<?> keycloakContainer = null;
    private String containerId = null;
    private Executor parallelReaperExecutor = Executors.newSingleThreadExecutor();

    public DockerKeycloakDistribution(boolean debug, boolean manualStop, boolean reCreate) {
        this.debug = debug;
        this.manualStop = manualStop;
    }

    private GenericContainer getKeycloakContainer() {
        RemoteDockerImage image;
        File distributionFile = new File("../../dist/" + File.separator + "target" + File.separator + "keycloak-" + Version.VERSION + ".tar.gz");
        if (!distributionFile.exists()) {
            distributionFile = Maven.resolveArtifact("org.keycloak", "keycloak-quarkus-dist").toFile();
        }
        if (!distributionFile.exists()) {
            throw new RuntimeException("Distribution archive " + distributionFile.getAbsolutePath() + " doesn't exist");
        }
        File dockerFile = new File("../../container/Dockerfile");
        if (dockerFile.exists()) {
            image = ((ImageFromDockerfile)((ImageFromDockerfile)((ImageFromDockerfile)new ImageFromDockerfile("keycloak-under-test", false).withFileFromFile("keycloak.tar.gz", distributionFile)).withFileFromFile("ubi-null.sh", this.dockerScriptFile)).withFileFromFile("Dockerfile", dockerFile)).withBuildArg("KEYCLOAK_DIST", "keycloak.tar.gz");
            this.toString();
        } else {
            image = new RemoteDockerImage(DockerImageName.parse((String)"quay.io/keycloak/keycloak"));
        }
        return new GenericContainer((Future)image).withExposedPorts(new Integer[]{8080}).withStartupAttempts(1).withStartupTimeout(Duration.ofSeconds(120L)).waitingFor((WaitStrategy)Wait.forListeningPort());
    }

    @Override
    public CLIResult run(List<String> arguments) {
        this.stop();
        try {
            this.exitCode = -1;
            this.stdout = "";
            this.stderr = "";
            this.containerId = null;
            this.backupConsumer = new ToStringConsumer();
            this.keycloakContainer = this.getKeycloakContainer();
            this.keycloakContainer.withLogConsumer((Consumer)this.backupConsumer).withCommand(arguments.toArray(new String[0])).start();
            this.containerId = this.keycloakContainer.getContainerId();
            this.waitForStableOutput();
        }
        catch (Exception cause) {
            this.exitCode = -1;
            this.stdout = this.backupConsumer.toUtf8String();
            this.stderr = this.backupConsumer.toUtf8String();
            this.cleanupContainer();
            this.keycloakContainer = null;
            LOGGER.warn((Object)"Failed to start Keycloak container", (Throwable)cause);
        }
        this.trySetRestAssuredPort();
        return CLIResult.create(this.getOutputStream(), this.getErrorStream(), this.getExitCode());
    }

    private void trySetRestAssuredPort() {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> restAssured = classLoader.loadClass("io.restassured.RestAssured");
            Field port = restAssured.getDeclaredField("port");
            port.set(null, this.keycloakContainer.getMappedPort(8080));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void waitForStableOutput() {
        int retry = 10;
        String lastLine = "";
        boolean stableOutput = false;
        while (!stableOutput) {
            if (this.keycloakContainer.isRunning()) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                String[] splitted = this.keycloakContainer.getLogs().split(System.lineSeparator());
                String newLastLine = splitted[splitted.length - 1];
                stableOutput = lastLine.equals(newLastLine) | --retry <= 0;
                lastLine = newLastLine;
                continue;
            }
            stableOutput = true;
        }
    }

    @Override
    public void stop() {
        try {
            if (this.keycloakContainer != null) {
                this.containerId = this.keycloakContainer.getContainerId();
                this.stdout = this.fetchOutputStream();
                this.stderr = this.fetchErrorStream();
                this.keycloakContainer.stop();
                this.exitCode = 0;
            }
        }
        catch (Exception cause) {
            this.exitCode = -1;
            throw new RuntimeException("Failed to stop the server", cause);
        }
        finally {
            this.cleanupContainer();
            this.keycloakContainer = null;
        }
    }

    private void cleanupContainer() {
        if (this.containerId != null) {
            try {
                final String finalContainerId = this.containerId;
                Runnable reaper = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ResourceReaper.instance().stopAndRemoveContainer(finalContainerId);
                        }
                        catch (Exception cause) {
                            throw new RuntimeException("Failed to stop and remove container", cause);
                        }
                    }
                };
                this.parallelReaperExecutor.execute(reaper);
            }
            catch (Exception cause) {
                throw new RuntimeException("Failed to schecdule the removal of the container", cause);
            }
        }
    }

    private String fetchOutputStream() {
        if (this.keycloakContainer != null && this.keycloakContainer.isRunning()) {
            return this.keycloakContainer.getLogs(new OutputFrame.OutputType[]{OutputFrame.OutputType.STDOUT});
        }
        if (this.stdout.isEmpty()) {
            return this.backupConsumer.toUtf8String();
        }
        return this.stdout;
    }

    @Override
    public List<String> getOutputStream() {
        return List.of(this.fetchOutputStream().split("\n"));
    }

    public String fetchErrorStream() {
        if (this.keycloakContainer != null && this.keycloakContainer.isRunning()) {
            return this.keycloakContainer.getLogs(new OutputFrame.OutputType[]{OutputFrame.OutputType.STDERR});
        }
        if (this.stderr.isEmpty()) {
            return this.backupConsumer.toUtf8String();
        }
        return this.stderr;
    }

    @Override
    public List<String> getErrorStream() {
        return List.of(this.fetchErrorStream().split("\n"));
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public boolean isManualStop() {
        return this.manualStop;
    }

    @Override
    public <D extends KeycloakDistribution> D unwrap(Class<D> type) {
        if (!KeycloakDistribution.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Not a " + KeycloakDistribution.class + " type");
        }
        if (type.isInstance(this)) {
            return (D)this;
        }
        throw new IllegalArgumentException("Not a " + type + " type");
    }
}

