/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.it.junit5.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.keycloak.it.junit5.extension.LegacyStore;
import org.keycloak.it.junit5.extension.WithDatabase;

final class ServerOptions
extends ArrayList<String> {
    private static final Predicate<String> IGNORED_ARGUMENTS = ((Predicate<String>)s -> false).or("--optimized"::equals).or("export"::equals).or("import"::equals).or("--help"::equals).or("--help-all"::equals).or("-h"::equals).or("show-config"::equals);

    ServerOptions(LegacyStore legacyStoreConfig, WithDatabase withDatabase, List<String> rawOptions) {
        if (rawOptions.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Predicate<String>> entry : this.getDefaultOptions(legacyStoreConfig, withDatabase).entrySet()) {
            if (this.contains(entry.getKey()) || rawOptions.stream().anyMatch(entry.getValue())) continue;
            this.add(entry.getKey());
        }
        this.addAll(0, rawOptions);
    }

    private Map<String, Predicate<String>> getDefaultOptions(LegacyStore legacyStoreConfig, WithDatabase withDatabase) {
        HashMap<String, Predicate<String>> defaultOptions = new HashMap<String, Predicate<String>>();
        defaultOptions.put("--cache=local", this.ignoreCacheLocal(legacyStoreConfig));
        return defaultOptions;
    }

    private Predicate<String> ignoreCacheLocal(final LegacyStore legacyStoreConfig) {
        return new Predicate<String>(){

            @Override
            public boolean test(String arg) {
                return arg.contains("--cache") || legacyStoreConfig == null || !legacyStoreConfig.defaultLocalCache();
            }
        }.or(IGNORED_ARGUMENTS);
    }

    private Predicate<String> ignoreStorageChm(final LegacyStore legacyStoreConfig, final WithDatabase withDatabase) {
        return new Predicate<String>(){

            @Override
            public boolean test(String arg) {
                return arg.contains("--storage") || legacyStoreConfig != null || withDatabase != null;
            }
        }.or(IGNORED_ARGUMENTS);
    }
}

