/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.it.junit5.extension;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.keycloak.it.junit5.extension.CLIResult;
import org.keycloak.it.junit5.extension.DistributionTest;
import org.keycloak.it.junit5.extension.ServerOptions;
import org.keycloak.it.junit5.extension.Storage;
import org.keycloak.it.junit5.extension.WithDatabase;
import org.keycloak.it.utils.KeycloakDistribution;

public class KeycloakDistributionDecorator
implements KeycloakDistribution {
    private Storage storageConfig;
    private WithDatabase databaseConfig;
    private DistributionTest config;
    private KeycloakDistribution delegate;

    public KeycloakDistributionDecorator(Storage storageConfig, WithDatabase databaseConfig, DistributionTest config, KeycloakDistribution delegate) {
        this.storageConfig = storageConfig;
        this.databaseConfig = databaseConfig;
        this.config = config;
        this.delegate = delegate;
    }

    @Override
    public CLIResult run(List<String> rawArgs) {
        ArrayList<String> args = new ArrayList<String>(rawArgs);
        args.addAll(List.of(this.config.defaultOptions()));
        return this.delegate.run(new ServerOptions(this.storageConfig, this.databaseConfig, args));
    }

    @Override
    public void stop() {
        this.delegate.stop();
    }

    @Override
    public List<String> getOutputStream() {
        return this.delegate.getOutputStream();
    }

    @Override
    public List<String> getErrorStream() {
        return this.delegate.getErrorStream();
    }

    @Override
    public int getExitCode() {
        return this.delegate.getExitCode();
    }

    @Override
    public boolean isDebug() {
        return this.delegate.isDebug();
    }

    @Override
    public boolean isManualStop() {
        return this.delegate.isManualStop();
    }

    @Override
    public String[] getCliArgs(List<String> arguments) {
        return this.delegate.getCliArgs(arguments);
    }

    @Override
    public void setManualStop(boolean manualStop) {
        this.delegate.setManualStop(manualStop);
    }

    @Override
    public void setQuarkusProperty(String key, String value) {
        this.delegate.setQuarkusProperty(key, value);
    }

    @Override
    public void setProperty(String key, String value) {
        this.delegate.setProperty(key, value);
    }

    @Override
    public void deleteQuarkusProperties() {
        this.delegate.deleteQuarkusProperties();
    }

    @Override
    public void copyOrReplaceFileFromClasspath(String file, Path distDir) {
        this.delegate.copyOrReplaceFileFromClasspath(file, distDir);
    }

    @Override
    public void removeProperty(String name) {
        this.delegate.removeProperty(name);
    }

    @Override
    public void setEnvVar(String name, String value) {
        this.delegate.setEnvVar(name, value);
    }

    @Override
    public void copyOrReplaceFile(Path file, Path targetFile) {
        this.delegate.copyOrReplaceFile(file, targetFile);
    }

    @Override
    public void assertStopped() {
        this.delegate.assertStopped();
    }

    @Override
    public void setRequestPort() {
        this.delegate.setRequestPort();
    }

    @Override
    public void setRequestPort(int port) {
        this.delegate.setRequestPort(port);
    }

    @Override
    public <D extends KeycloakDistribution> D unwrap(Class<D> type) {
        if (!KeycloakDistribution.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Not a " + KeycloakDistribution.class + " type");
        }
        if (type.isInstance(this.delegate)) {
            return (D)this.delegate;
        }
        throw new IllegalArgumentException("Not a " + type + " type");
    }
}

