/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.it.junit5.extension;

import java.time.Duration;
import java.util.stream.Stream;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.configuration.XMLStringConfiguration;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.PullPolicy;

public class InfinispanContainer
extends GenericContainer<InfinispanContainer> {
    private final Logger LOG = Logger.getLogger(((Object)((Object)this)).getClass());
    public static final String PORT = System.getProperty("keycloak.externalInfinispan.port", "11222");
    public static final String USERNAME = System.getProperty("keycloak.externalInfinispan.username", "keycloak");
    public static final String PASSWORD = System.getProperty("keycloak.externalInfinispan.password", "Password1!");
    public static RemoteCacheManager remoteCacheManager;

    public InfinispanContainer() {
        super(InfinispanContainer.getImageName());
        this.withEnv("USER", USERNAME);
        this.withEnv("PASS", PASSWORD);
        this.withNetworkMode("host");
        if (InfinispanContainer.getImageName().startsWith("quay.io/infinispan-test")) {
            this.withImagePullPolicy(PullPolicy.alwaysPull());
        }
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Infinispan Server.*started in.*", (int)1));
        this.withStartupTimeout(Duration.ofMinutes(5L));
    }

    private static String getImageName() {
        String INFINISPAN_IMAGE = System.getProperty("kc.infinispan.container.image");
        if (INFINISPAN_IMAGE.matches("quay.io/infinispan/.*-SNAPSHOT")) {
            INFINISPAN_IMAGE = INFINISPAN_IMAGE.replaceAll("quay.io/infinispan/", "quay.io/infinispan-test/");
            INFINISPAN_IMAGE = INFINISPAN_IMAGE.replaceAll("[0-9]*-SNAPSHOT$", "x");
        }
        return INFINISPAN_IMAGE;
    }

    private void establishHotRodConnection() {
        ConfigurationBuilder configBuilder = new ConfigurationBuilder().addServers(this.getContainerIpAddress() + ":11222").security().authentication().username(this.getUsername()).password(this.getPassword()).clientIntelligence(ClientIntelligence.BASIC);
        configBuilder.statistics().enable().statistics().jmxEnable();
        remoteCacheManager = new RemoteCacheManager(configBuilder.build());
    }

    public void start() {
        super.start();
        this.establishHotRodConnection();
        Stream.of("sessions", "actionTokens", "authenticationSessions", "clientSessions", "offlineSessions", "offlineClientSessions", "loginFailures", "work").forEach(cacheName -> {
            this.LOG.infof("Creating cache '%s'", cacheName);
            this.createCache(remoteCacheManager, (String)cacheName);
        });
    }

    public void createCache(RemoteCacheManager remoteCacheManager, String cacheName) {
        String xml = String.format("<distributed-cache name=\"%s\" mode=\"SYNC\" owners=\"2\"></distributed-cache>", cacheName);
        remoteCacheManager.administration().getOrCreateCache(cacheName, (BasicConfiguration)new XMLStringConfiguration(xml));
    }

    public String getPort() {
        return PORT;
    }

    public String getUsername() {
        return USERNAME;
    }

    public String getPassword() {
        return PASSWORD;
    }
}

