/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.it.utils;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.utils.BuildToolHelper;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;

public final class Maven {
    public static Path resolveArtifact(String groupId, String artifactId) {
        try {
            Path classPathDir = Paths.get(Thread.currentThread().getContextClassLoader().getResource(".").toURI());
            Path projectDir = BuildToolHelper.getProjectDir((Path)classPathDir);
            BootstrapMavenContext ctx = new BootstrapMavenContext(BootstrapMavenContext.config().setPreferPomsFromWorkspace(true).setWorkspaceModuleParentHierarchy(true).setCurrentProject(projectDir.toString()));
            LocalProject project = ctx.getCurrentProject();
            RepositorySystem repositorySystem = ctx.getRepositorySystem();
            List remoteRepositories = ctx.getRemoteRepositories();
            ArtifactDescriptorResult projectDescriptor = repositorySystem.readArtifactDescriptor(ctx.getRepositorySystemSession(), new ArtifactDescriptorRequest().setArtifact((Artifact)new DefaultArtifact(project.getGroupId(), project.getArtifactId(), "pom", project.getVersion())).setRepositories(remoteRepositories));
            ArrayList<Dependency> dependencies = new ArrayList<Dependency>(projectDescriptor.getDependencies());
            dependencies.addAll(projectDescriptor.getManagedDependencies());
            Artifact artifact = Maven.resolveArtifact(groupId, artifactId, dependencies);
            if (artifact == null) {
                Maven.resolveArtifact(groupId, artifactId, projectDescriptor.getManagedDependencies());
            }
            if (artifact == null) {
                artifact = Maven.resolveArtifactRecursively(ctx, projectDescriptor, groupId, artifactId);
            }
            if (artifact == null) {
                throw new RuntimeException("Failed to resolve artifact [" + groupId + ":" + artifactId + "] from project [" + projectDescriptor.getArtifact() + "] dependency graph");
            }
            return repositorySystem.resolveArtifact(ctx.getRepositorySystemSession(), new ArtifactRequest().setArtifact(artifact).setRepositories(remoteRepositories)).getArtifact().getFile().toPath();
        }
        catch (Exception cause) {
            throw new RuntimeException("Failed to resolve artifact: " + groupId + ":" + artifactId, cause);
        }
    }

    private static Artifact resolveArtifact(String groupId, String artifactId, List<Dependency> dependencies) {
        for (Dependency dependency : dependencies) {
            Artifact artifact = dependency.getArtifact();
            if (!artifact.getGroupId().equals(groupId) || !artifact.getArtifactId().equals(artifactId)) continue;
            return artifact;
        }
        return null;
    }

    private static Artifact resolveArtifactRecursively(BootstrapMavenContext ctx, ArtifactDescriptorResult artifactDescriptor, final String groupId, final String artifactId) throws BootstrapMavenException, DependencyResolutionException {
        CollectRequest collectRequest = MavenArtifactResolver.newCollectRequest((Artifact)artifactDescriptor.getArtifact(), (List)artifactDescriptor.getDependencies(), List.of(), List.of(), (List)ctx.getRemoteRepositories());
        List artifactResults = ctx.getRepositorySystem().resolveDependencies(ctx.getRepositorySystemSession(), new DependencyRequest().setFilter(new DependencyFilter(){

            public boolean accept(DependencyNode node, List<DependencyNode> parents) {
                Dependency dependency = node.getDependency();
                if (dependency == null) {
                    return false;
                }
                Artifact artifact = dependency.getArtifact();
                return artifact.getGroupId().equals(groupId) && artifact.getArtifactId().equals(artifactId);
            }
        }).setCollectRequest(collectRequest)).getArtifactResults();
        if (artifactResults.isEmpty()) {
            return null;
        }
        if (artifactResults.size() > 1) {
            throw new RuntimeException("Unexpected number of resolved artifacts: " + artifactResults);
        }
        return ((ArtifactResult)artifactResults.get(0)).getArtifact();
    }
}

