/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.it.junit5.extension;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.test.junit.main.LaunchResult;
import java.util.List;
import java.util.regex.Pattern;
import org.junit.jupiter.api.Assertions;
import org.testcontainers.shaded.org.hamcrest.Matcher;
import org.testcontainers.shaded.org.hamcrest.MatcherAssert;
import org.testcontainers.shaded.org.hamcrest.Matchers;

public interface CLIResult
extends LaunchResult {
    public static CLIResult create(final List<String> outputStream, final List<String> errStream, final int exitCode) {
        return new CLIResult(){

            public List<String> getOutputStream() {
                return outputStream;
            }

            public String getErrorOutput() {
                return String.join((CharSequence)"\n", errStream).replace("\r", "");
            }

            public List<String> getErrorStream() {
                return errStream;
            }

            public int exitCode() {
                return exitCode;
            }
        };
    }

    default public void assertStarted() {
        Assertions.assertFalse((boolean)this.getOutput().contains("The delayed handler's queue was overrun and log record(s) were lost (Did you forget to configure logging?)"), () -> "The standard Output:\n" + this.getOutput() + "should not contain a warning about log queue overrun.");
        Assertions.assertTrue((boolean)this.getOutput().contains("Listening on:"), () -> "The standard output:\n" + this.getOutput() + "does include \"Listening on:\"");
        this.assertNotDevMode();
    }

    default public void assertNotDevMode() {
        Assertions.assertFalse((boolean)this.getOutput().contains("Running the server in development mode."), () -> "The standard output:\n" + this.getOutput() + "\ndoes include the Start Dev output");
    }

    default public void assertStartedDevMode() {
        Assertions.assertTrue((boolean)this.getOutput().contains("Running the server in development mode."), () -> "The standard output:\n" + this.getOutput() + "\ndoesn't include the Start Dev output");
    }

    default public void assertError(String msg) {
        Assertions.assertTrue((boolean)this.getErrorOutput().contains(msg), () -> "The Error Output:\n " + this.getErrorOutput() + "\ndoesn't contains " + msg);
    }

    default public void assertNoError(String msg) {
        Assertions.assertFalse((boolean)this.getErrorOutput().contains(msg), () -> "The Error Output:\n " + this.getErrorOutput() + "\n contains " + msg);
    }

    default public void assertMessage(String message) {
        MatcherAssert.assertThat((Object)this.getOutput(), (Matcher)Matchers.containsString((String)message));
    }

    default public void assertNoMessage(String message) {
        MatcherAssert.assertThat((Object)this.getOutput(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)message)));
    }

    default public void assertMessageWasShownExactlyNumberOfTimes(String message, long numberOfShownTimes) {
        long msgCount = this.getOutput().lines().filter(oneMessage -> oneMessage.contains(message)).count();
        MatcherAssert.assertThat((Object)msgCount, (Matcher)Matchers.equalTo((Object)numberOfShownTimes));
    }

    default public void assertBuild() {
        this.assertMessage("Server configuration updated and persisted");
    }

    default public void assertNoBuild() {
        Assertions.assertFalse((boolean)this.getOutput().contains("Server configuration updated and persisted"));
    }

    default public void assertBuildRuntimeMismatchWarning(String quarkusBuildtimePropKey) {
        Assertions.assertTrue((boolean)this.getOutput().contains(" - " + quarkusBuildtimePropKey + " is set to 'true' but it is build time fixed to 'false'. Did you change the property " + quarkusBuildtimePropKey + " after building the application?"));
    }

    default public boolean isClustered() {
        return this.getOutput().contains("Starting JGroups channel `ISPN`");
    }

    default public void assertLocalCache() {
        Assertions.assertFalse((boolean)this.isClustered());
    }

    default public void assertClusteredCache() {
        Assertions.assertTrue((boolean)this.isClustered());
    }

    default public void assertJsonLogDefaultsApplied() throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        String[] splittedOutput = this.getOutput().split("\n");
        int counter = 0;
        for (String line : splittedOutput) {
            if (!line.trim().startsWith("{")) {
                ++counter;
                continue;
            }
            JsonNode json = objectMapper.readTree(line);
            Assertions.assertTrue((boolean)json.has("timestamp"));
            Assertions.assertTrue((boolean)json.has("message"));
            Assertions.assertTrue((boolean)json.has("level"));
        }
        if (counter == splittedOutput.length) {
            Assertions.fail((String)"No JSON found in output.");
        }
    }

    default public void assertStringCount(String msg, int count) {
        Pattern pattern = Pattern.compile(msg);
        Assertions.assertEquals((long)count, (long)pattern.matcher(this.getOutput()).results().count());
    }
}

